/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

public class JavaScriptLanguageFeatureParser
implements ILanguageFeatureParser {
    private static final String MOCHA_DESCRIBE = "describe";

    JavaScriptLanguageFeatureParser() {
    }

    @Override
    public ELanguage getLanguage() {
        return ELanguage.JAVASCRIPT;
    }

    public boolean isDescribeBlock(ShallowEntity entity) {
        ShallowEntity parentEntity = entity.getParent();
        return parentEntity != null && parentEntity.getType() == EShallowEntityType.STATEMENT && MOCHA_DESCRIBE.equals(parentEntity.getName());
    }

    public boolean isConstructor(ShallowEntity entity) {
        return this.isES6ClassConstructor(entity) || this.isES5ClassConstructor(entity);
    }

    @VisibleForTesting
    boolean isES6ClassConstructor(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && "constructor".equals(entity.getSubtype());
    }

    @VisibleForTesting
    boolean isES5ClassConstructor(ShallowEntity entity) {
        String entityName = entity.getName();
        boolean functionTypeMatches = "named function".equals(entity.getSubtype()) || this.isDefinedInTopLevelImmediatelyInvokedFunctionExpression(entity) && "assigned function".equals(entity.getSubtype());
        return entity.getType() == EShallowEntityType.METHOD && functionTypeMatches && entityName != null && Character.isUpperCase(entityName.charAt(0)) && !JavaScriptLanguageFeatureParser.hasReturnStatementWithJSX(entity);
    }

    public boolean isDefinedInAngularJsMethod(ShallowEntity entity) {
        return ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parentEntity -> parentEntity.getType() == EShallowEntityType.METHOD && parentEntity.getSubtype() != null && parentEntity.getSubtype().startsWith("AngularJS")).isPresent();
    }

    public boolean isDefinedInYuiModule(ShallowEntity entity) {
        return ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parentEntity -> parentEntity.getType() == EShallowEntityType.MODULE && "YUI module".equals(parentEntity.getSubtype())).isPresent();
    }

    @VisibleForTesting
    boolean isDefinedInTopLevelImmediatelyInvokedFunctionExpression(ShallowEntity entity) {
        if (entity.getParent() == null) {
            return false;
        }
        return this.isTopLevelImmediatelyInvokedFunctionExpression(entity.getParent());
    }

    public boolean isTopLevelImmediatelyInvokedFunctionExpression(ShallowEntity entity) {
        boolean isStatementStartingWithParens;
        if (entity.getParent() == null) {
            return false;
        }
        ShallowEntity topParent = entity.getParent();
        boolean isLocalVariableDeclaration = topParent.getSubtype().equals("local variable");
        boolean bl = isStatementStartingWithParens = topParent.getSubtype().equals("simple statement") && topParent.getName() != null && topParent.getName().equals("(");
        if (!entity.getSubtype().equals("anonymous function") || !isLocalVariableDeclaration && !isStatementStartingWithParens) {
            return false;
        }
        List tokens = topParent.getAllTokensOfFile();
        int parentEnd = entity.getEndTokenIndex();
        int topParentEnd = topParent.getEndTokenIndex() - 2;
        if (parentEnd < tokens.size() - 1 && (((IToken)tokens.get(parentEnd)).getType() != ETokenType.RPAREN || ((IToken)tokens.get(parentEnd + 1)).getType() != ETokenType.LPAREN)) {
            return false;
        }
        return ((IToken)tokens.get(topParentEnd)).getType() == ETokenType.RPAREN || ((IToken)tokens.get(topParentEnd + 1)).getType() == ETokenType.RPAREN;
    }

    public boolean isDefinedInLowerLevelOfTopLevelImmediatelyInvokedFunctionExpression(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null || this.isConstructor(parent)) {
            return false;
        }
        if (!this.isDefinedInTopLevelImmediatelyInvokedFunctionExpression(parent)) {
            return this.isDefinedInLowerLevelOfTopLevelImmediatelyInvokedFunctionExpression(parent);
        }
        return true;
    }

    public boolean isMethodDefinedInImmediatelyReturnedObject(ShallowEntity entity) {
        return entity.getSubtype() != null && entity.getSubtype().equals("attribute function") && entity.getParent() != null && "return".equals(entity.getParent().getName());
    }

    private static boolean containsJSXToken(ShallowEntity entity) {
        return entity.ownTokens().stream().flatMap(Collection::stream).anyMatch(t -> t.getType() == ETokenType.JSX);
    }

    private static boolean hasReturnStatementWithJSX(ShallowEntity entity) {
        if (!entity.hasChildren()) {
            return false;
        }
        return entity.getChildrenOfType(EShallowEntityType.STATEMENT).stream().anyMatch(e -> "simple statement".equals(e.getSubtype()) && ETokenType.RETURN.toString().equalsIgnoreCase(e.getName()) && JavaScriptLanguageFeatureParser.containsJSXToken(e));
    }
}

