/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public class VisualBasicLanguageFeatureParser
implements ILanguageFeatureParser {
    private static final TokenPattern VB_CLASS_PATTERN = TokenPattern.of().sequence(ETokenType.CLASS, ETokenType.IDENTIFIER).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, true).optional(TokenPattern.of().sequence(ETokenType.INHERITS).sequence(ETokenType.IDENTIFIER, TokenPattern.of().repeated(ETokenType.DOT, ETokenType.IDENTIFIER)).group(0));

    @Override
    public ELanguage getLanguage() {
        return ELanguage.VB;
    }

    public List<IToken> getSuperclass(@NonNull ShallowEntity classEntity) {
        Preconditions.checkArgument((classEntity.getType() == EShallowEntityType.TYPE && "class".equals(classEntity.getSubtype()) ? 1 : 0) != 0);
        return Objects.requireNonNull(VB_CLASS_PATTERN.findFirstMatch((List<IToken>)classEntity.ownStartTokens())).groupTokens(0);
    }
}

