/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.clike.ConditionalBlock;
import eu.cqse.check.framework.util.clike.ConditionalBlockGroupBase;
import eu.cqse.check.framework.util.clike.ConditionalBlockUtils;
import eu.cqse.check.framework.util.clike.EConditionalType;
import eu.cqse.check.framework.util.clike.IfBlockGroup;
import eu.cqse.check.framework.util.clike.SwitchBlockGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ConditionalBlockGroupExtractor {
    public static List<ConditionalBlockGroupBase> findCorrespondingBlockGroups(ShallowEntity entity) throws CheckException {
        if (PreprocessorUtils.isEntityMacroExpanded(entity)) {
            return CollectionUtils.emptyList();
        }
        ArrayList<ConditionalBlockGroupBase> groupedBlocks = new ArrayList<ConditionalBlockGroupBase>();
        EConditionalType blockType = ConditionalBlockUtils.getBlockTypeFromEntity(entity);
        if (blockType != null) {
            switch (blockType) {
                case IF: {
                    groupedBlocks.add(ConditionalBlockGroupExtractor.createIfBlockGroup(entity));
                    break;
                }
                case SWITCH: {
                    groupedBlocks.add(ConditionalBlockGroupExtractor.createSwitchBlockGroup(entity));
                    break;
                }
            }
        }
        groupedBlocks.addAll(ConditionalBlockGroupExtractor.findCorrespondingBlockGroups((List<ShallowEntity>)entity.getChildren()));
        return groupedBlocks;
    }

    public static List<ConditionalBlockGroupBase> findCorrespondingBlockGroups(List<ShallowEntity> entities) throws CheckException {
        ArrayList<ConditionalBlockGroupBase> groupedBlocks = new ArrayList<ConditionalBlockGroupBase>();
        if (entities.isEmpty()) {
            return groupedBlocks;
        }
        ShallowEntity parent = entities.get(0).getParent();
        for (ShallowEntity entity : entities) {
            ShallowEntity actualParent = entity.getParent();
            if (actualParent != parent) {
                String message = "The ShallowEntity: [" + entity.getSubtype().toUpperCase() + "] spanning lines ";
                message = message + entity.getStartLine() + " through " + entity.getEndLine();
                message = message + " has a different parent from its siblings";
                message = message + " .Expected parent: [" + parent.getSubtype() + "] spanning lines " + parent.getStartLine() + " through " + parent.getEndLine();
                message = message + " .Actual parent: [" + actualParent.getSubtype() + "] spanning lines " + actualParent.getStartLine() + " through " + actualParent.getEndLine();
                message = message + " File: " + TokenStreamUtils.determineMostSpecificOrigin(entity.getAllTokensOfFile());
                throw new IllegalArgumentException(message);
            }
            List<ConditionalBlockGroupBase> childrenBlockGroups = ConditionalBlockGroupExtractor.findCorrespondingBlockGroups(entity);
            if (childrenBlockGroups.isEmpty()) continue;
            groupedBlocks.addAll(childrenBlockGroups);
        }
        return groupedBlocks;
    }

    private static IfBlockGroup createIfBlockGroup(ShallowEntity ifEntity) {
        UnmodifiableList neighboringEntities = Objects.requireNonNull(ifEntity.getParent()).getChildren();
        int ifIndex = neighboringEntities.indexOf(ifEntity);
        IfBlockGroup ifblockGroup = new IfBlockGroup();
        ConditionalBlock ifBlock = new ConditionalBlock(ConditionalBlockUtils.getBlockTypeFromEntity(ifEntity), ConditionalBlockUtils.extractCondition(ifEntity), (List<ShallowEntity>)ifEntity.getChildren());
        ifblockGroup.getCorrespondingBlocks().add(ifBlock);
        for (int nextIndex = ifIndex + 1; nextIndex < neighboringEntities.size(); ++nextIndex) {
            ShallowEntity nextEntity = (ShallowEntity)neighboringEntities.get(nextIndex);
            if (PreprocessorUtils.isEntityMacroExpanded(nextEntity)) continue;
            EConditionalType blockType = ConditionalBlockUtils.getBlockTypeFromEntity(nextEntity);
            if (!ConditionalBlockUtils.BLOCKS_CORRESPONDING_TO_IF.contains((Object)blockType)) break;
            if (blockType == EConditionalType.ELSE_IF) {
                ifblockGroup.getCorrespondingBlocks().add(new ConditionalBlock(blockType, ConditionalBlockUtils.extractCondition(nextEntity), (List<ShallowEntity>)nextEntity.getChildren()));
                continue;
            }
            if (blockType != EConditionalType.ELSE) continue;
            ifblockGroup.getCorrespondingBlocks().add(new ConditionalBlock(blockType, (List<ShallowEntity>)nextEntity.getChildren()));
            break;
        }
        return ifblockGroup;
    }

    private static SwitchBlockGroup createSwitchBlockGroup(ShallowEntity switchEntity) {
        List<ShallowEntity> metas = ConditionalBlockGroupExtractor.findMetaStatements(switchEntity);
        UnmodifiableList innerStatements = switchEntity.getChildren();
        SwitchBlockGroup switchBlockGroup = new SwitchBlockGroup();
        switchBlockGroup.setSurroundingEntity(switchEntity);
        for (int i = 0; i < metas.size(); ++i) {
            EConditionalType blockType;
            int nextMetaParentIndex;
            ShallowEntity currentMeta = metas.get(i);
            if (PreprocessorUtils.isEntityMacroExpanded(currentMeta)) continue;
            int currentMetaParentIndex = innerStatements.indexOf(currentMeta);
            List<ShallowEntity> metaStatements = innerStatements.subList(currentMetaParentIndex + 1, nextMetaParentIndex = i + 1 < metas.size() ? innerStatements.indexOf(metas.get(i + 1)) : innerStatements.size());
            if (metaStatements.isEmpty() || (blockType = ConditionalBlockUtils.getBlockTypeFromEntity(currentMeta)) == null) continue;
            if (blockType == EConditionalType.CASE) {
                switchBlockGroup.getCorrespondingBlocks().add(new ConditionalBlock(blockType, ConditionalBlockUtils.extractCondition(currentMeta), metaStatements));
                continue;
            }
            switchBlockGroup.getCorrespondingBlocks().add(new ConditionalBlock(blockType, metaStatements));
        }
        return switchBlockGroup;
    }

    private static List<ShallowEntity> findMetaStatements(ShallowEntity entity) {
        ArrayList<ShallowEntity> metas = new ArrayList<ShallowEntity>();
        for (ShallowEntity innerStatement : entity.getChildren()) {
            if (innerStatement.getType() != EShallowEntityType.META) continue;
            metas.add(innerStatement);
        }
        return metas;
    }
}

