/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp.alignment;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.cpp.alignment.AttributeEntityAlignmentInfoExtractor;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.EntityAlignmentInfoBase;
import eu.cqse.check.framework.util.cpp.alignment.IAlignmentInfoExtractor;
import eu.cqse.check.framework.util.cpp.alignment.StructAlignmentInfoExtractor;
import eu.cqse.check.framework.util.cpp.alignment.TypeEntityAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.UnionAlignmentInfoExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class DataAlignmentInfoExtractorCoordinator {
    private static final List<Supplier<IAlignmentInfoExtractor<?>>> AVAILABLE_EXTRACTORS = List.of(AttributeEntityAlignmentInfoExtractor::getInstance, StructAlignmentInfoExtractor::getInstance, UnionAlignmentInfoExtractor::getInstance);

    public static List<DataAlignmentInfo> extract(List<ShallowEntity> entities, List<IToken> nonPreprocessedTokens, int architectureWordSizeInBytes) {
        ArrayList entityAlignmentInfos = new ArrayList();
        LinkedList<ShallowEntity> remainingEntities = new LinkedList<ShallowEntity>(entities);
        while (!remainingEntities.isEmpty()) {
            ShallowEntity subsequentEntity;
            ShallowEntity entity = (ShallowEntity)remainingEntities.remove();
            IAlignmentInfoExtractor<?> extractor = DataAlignmentInfoExtractorCoordinator.getApplicableExtractor(entity);
            if (extractor == null) continue;
            Object entityAlignmentInfo = extractor.extract(entity, nonPreprocessedTokens, architectureWordSizeInBytes);
            if (entityAlignmentInfo instanceof TypeEntityAlignmentInfo && (subsequentEntity = (ShallowEntity)remainingEntities.peek()) != null && subsequentEntity.includedTokens().contains((Object)((TypeEntityAlignmentInfo)entityAlignmentInfo).getLastRelevantToken())) {
                remainingEntities.remove();
            }
            entityAlignmentInfos.add(entityAlignmentInfo);
        }
        return entityAlignmentInfos.stream().map(EntityAlignmentInfoBase::getEffectiveMemoryImpact).flatMap(Collection::stream).toList();
    }

    private static IAlignmentInfoExtractor<?> getApplicableExtractor(ShallowEntity entity) {
        for (Supplier<IAlignmentInfoExtractor<?>> extractorSupplier : AVAILABLE_EXTRACTORS) {
            IAlignmentInfoExtractor<?> extractor = extractorSupplier.get();
            if (!extractor.isApplicable(entity)) continue;
            return extractor;
        }
        return null;
    }
}

