/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionParser;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabFunctionBlockCodeExtractionUtils;
import eu.cqse.check.simulink.stateflow_data_typing.StateflowVariableTypeExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkBus;
import org.conqat.lib.simulink.builder.SimulinkBusElement;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.jspecify.annotations.NonNull;

public class MatlabActionTypeResolver {
    public static final String DEFAULT_NUMBER_TYPE = "double";
    public static final MatlabActionAstNode EMPTY_ROOT_NODE = new MatlabActionAstNode(EMatlabActionEntityType.STATEMENT_LIST, Collections.emptyList(), Collections.emptyList());
    private final Map<String, String> variableDataTypes = new HashMap<String, String>();
    private final Map<MatlabActionAstNode, String> astNodeDataTypes = new HashMap<MatlabActionAstNode, String>();
    private final Set<String> localDefinedVariables = new HashSet<String>();
    private final StateflowVariableTypeExtractor typeExtractor;
    private final MatlabActionAstNode rootNode;
    private final List<SimulinkDataDictionary> dataDictionaries;
    private StateflowState state = null;
    private StateflowTransition transition = null;
    private static final Pattern CAST_PATTERN = Pattern.compile("cast\\(.*,'(.*)'\\)");

    public MatlabActionTypeResolver(MatlabActionAstNode rootNode, StateflowState state, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        this.rootNode = rootNode;
        this.state = state;
        this.typeExtractor = new StateflowVariableTypeExtractor(resolvedDataTypes);
        this.dataDictionaries = dataDictionaries;
    }

    private MatlabActionTypeResolver(MatlabActionAstNode rootNode, StateflowTransition transition, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        this.rootNode = rootNode;
        this.transition = transition;
        this.typeExtractor = new StateflowVariableTypeExtractor(resolvedDataTypes);
        this.dataDictionaries = dataDictionaries;
    }

    public static MatlabActionTypeResolver from(List<IToken> tokens, StateflowState state, SimulinkResolvedDataTypes simulinkResolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) throws MatlabActionParserException {
        while (TokenStreamUtils.startsWith(tokens, ETokenType.EOL)) {
            tokens = tokens.subList(1, tokens.size());
        }
        if (tokens.isEmpty() || TokenStreamUtils.getLanguage(tokens) != ELanguage.MATLAB) {
            return new MatlabActionTypeResolver(EMPTY_ROOT_NODE, state, simulinkResolvedDataTypes, dataDictionaries);
        }
        MatlabActionAstNode rootNode = new MatlabActionParser(tokens).parse();
        MatlabActionTypeResolver resolver = new MatlabActionTypeResolver(rootNode, state, simulinkResolvedDataTypes, dataDictionaries);
        resolver.deduceTypesRecursively(rootNode);
        return resolver;
    }

    public static MatlabActionTypeResolver from(List<IToken> tokens, StateflowTransition transition, SimulinkResolvedDataTypes simulinkResolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) throws MatlabActionParserException {
        while (TokenStreamUtils.startsWith(tokens, ETokenType.EOL)) {
            tokens = tokens.subList(1, tokens.size());
        }
        if (tokens.isEmpty() || TokenStreamUtils.getLanguage(tokens) != ELanguage.MATLAB) {
            return new MatlabActionTypeResolver(EMPTY_ROOT_NODE, transition, simulinkResolvedDataTypes, dataDictionaries);
        }
        MatlabActionAstNode rootNode = new MatlabActionParser(tokens).parse();
        MatlabActionTypeResolver resolver = new MatlabActionTypeResolver(rootNode, transition, simulinkResolvedDataTypes, dataDictionaries);
        resolver.deduceTypesRecursively(rootNode);
        return resolver;
    }

    public static List<MatlabActionTypeResolver> fromMatlabFunctionBlock(SimulinkBlock matlabFunctionBlock, SimulinkResolvedDataTypes simulinkResolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) throws MatlabActionParserException {
        Optional<StateflowState> state = MatlabFunctionBlockCodeExtractionUtils.extractStateflowStateFromMatlabFunctionBlock(matlabFunctionBlock);
        if (!state.isPresent()) {
            return Collections.emptyList();
        }
        List<List<IToken>> methodBodies = MatlabFunctionBlockCodeExtractionUtils.extractMethodBodiesFromMatlabFunctionBlock(matlabFunctionBlock);
        ArrayList<MatlabActionTypeResolver> typeResolvers = new ArrayList<MatlabActionTypeResolver>();
        for (List<IToken> methodBody : methodBodies) {
            MatlabActionTypeResolver typeResolver = MatlabActionTypeResolver.from(methodBody, state.get(), simulinkResolvedDataTypes, dataDictionaries);
            typeResolvers.add(typeResolver);
        }
        return typeResolvers;
    }

    public static List<MatlabActionTypeResolver> fromMatlabFunctionNode(StateflowState matlabFunctionNode, SimulinkResolvedDataTypes simulinkResolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) throws MatlabActionParserException {
        CCSMAssert.isTrue((boolean)matlabFunctionNode.isMatlabFunction(), (String)"Method must be called with \"Matlab Function\" Stateflow nodes only");
        List<List<IToken>> methodBodies = MatlabFunctionBlockCodeExtractionUtils.extractMethodBodiesFromEmlScriptParameter(matlabFunctionNode);
        ArrayList<MatlabActionTypeResolver> typeResolvers = new ArrayList<MatlabActionTypeResolver>();
        for (List<IToken> methodBody : methodBodies) {
            MatlabActionTypeResolver typeResolver = MatlabActionTypeResolver.from(methodBody, matlabFunctionNode, simulinkResolvedDataTypes, dataDictionaries);
            typeResolvers.add(typeResolver);
        }
        return typeResolvers;
    }

    public String inferDataTypeOf(String variableName) {
        this.deduceTypesRecursively(this.rootNode);
        return this.variableDataTypes.getOrDefault(variableName, "Unknown");
    }

    public String inferDataTypeOf(MatlabActionAstNode astNode) {
        return this.astNodeDataTypes.getOrDefault(astNode, "Unknown");
    }

    public MatlabActionAstNode getRootNode() {
        return this.rootNode;
    }

    private void deduceTypesRecursively(MatlabActionAstNode astNode) {
        for (MatlabActionAstNode child : astNode.getChildren()) {
            this.deduceTypesRecursively(child);
        }
        this.deduceTypes(astNode);
    }

    private void deduceTypes(MatlabActionAstNode astNode) {
        switch (astNode.getType()) {
            case VARIABLE: {
                this.deduceVariableType(astNode);
                break;
            }
            case VARIABLE_WITH_TYPE: {
                this.deduceTypedVariableType(astNode);
                break;
            }
            case ASSIGNMENT: {
                this.deduceAssignmentType(astNode);
                break;
            }
            case UNARY_OPERATION: {
                this.deduceTypeOfUnaryOperation(astNode);
                break;
            }
            case ADDITION: 
            case SUBTRACTION: 
            case MULTIPLICATION: 
            case DIVISION: 
            case MODULO: 
            case POWER: {
                this.deduceBinaryOperatorDataTypes(astNode);
                break;
            }
            case COMPARISON: {
                this.deduceBooleanBinaryOperatorDataTypes(astNode);
                break;
            }
            case BOOL_OPERATION: {
                this.deduceBoolOperationTypes(astNode);
                break;
            }
            case FUNCTION: {
                this.deduceFunctionTypes(astNode);
                break;
            }
            case INTEGER_LITERAL: 
            case FLOATING_POINT_LITERAL: {
                this.astNodeDataTypes.put(astNode, DEFAULT_NUMBER_TYPE);
                break;
            }
            case BOOLEAN_LITERAL: {
                this.astNodeDataTypes.put(astNode, "boolean");
                break;
            }
            case STRING_LITERAL: {
                this.astNodeDataTypes.put(astNode, "string");
                break;
            }
            case TIME_LITERAL: {
                this.astNodeDataTypes.put(astNode, "datetime");
                break;
            }
            case PARENTHESIS: {
                this.astNodeDataTypes.put(astNode, this.astNodeDataTypes.getOrDefault(astNode.getChildren().get(0), "Unknown"));
                break;
            }
            case CHAIN: {
                this.deduceChainNodeType(astNode);
                break;
            }
        }
    }

    private void deduceChainNodeType(MatlabActionAstNode astNode) {
        String leftType = this.astNodeDataTypes.getOrDefault(astNode.getChildren().get(0), "Unknown");
        if (leftType.equals("Unknown") || astNode.getChildren().size() != 2 || astNode.getChildren().get(1).getType() != EMatlabActionEntityType.VARIABLE || astNode.getChildren().get(1).getTokens().isEmpty()) {
            this.astNodeDataTypes.put(astNode, "Unknown");
            return;
        }
        Optional<SimulinkBus> bus = this.findBusTypeWithName(leftType = StringUtils.stripPrefix((String)leftType, (String)"Bus: "));
        if (!bus.isPresent()) {
            this.astNodeDataTypes.put(astNode, "Unknown");
            return;
        }
        String elementName = astNode.getChildren().get(1).getTokens().get(0).getText();
        Optional busElement = bus.get().findElement(elementName);
        if (busElement.isPresent()) {
            this.astNodeDataTypes.put(astNode, ((SimulinkBusElement)busElement.get()).getDataType());
        } else {
            this.astNodeDataTypes.put(astNode, "Unknown");
        }
    }

    private @NonNull Optional<SimulinkBus> findBusTypeWithName(String busTypeName) {
        for (SimulinkDataDictionary dataDictionary : this.dataDictionaries) {
            for (SimulinkBus busType : dataDictionary.getBuses()) {
                if (!busType.getName().equals(busTypeName)) continue;
                return Optional.of(busType);
            }
        }
        return Optional.empty();
    }

    private void deduceTypeOfUnaryOperation(MatlabActionAstNode astNode) {
        MatlabActionAstNode child = astNode.getChildren().get(0);
        String childType = this.astNodeDataTypes.getOrDefault(child, "Unknown");
        this.astNodeDataTypes.put(astNode, childType);
    }

    private void deduceVariableType(MatlabActionAstNode astNode) {
        String variableName = astNode.getTokens().get(0).getText();
        Optional<String> resolvedType = this.determineType(variableName);
        if (resolvedType.isPresent()) {
            this.astNodeDataTypes.put(astNode, resolvedType.get());
            this.variableDataTypes.put(variableName, resolvedType.get());
        }
    }

    private void deduceTypedVariableType(MatlabActionAstNode astNode) {
        String variableType = astNode.getTokens().get(0).getText();
        String variableName = astNode.getTokens().get(1).getText();
        this.astNodeDataTypes.put(astNode, variableType);
        this.variableDataTypes.put(variableName, variableType);
    }

    private Optional<String> determineType(String variableName) {
        CCSMAssert.isFalse((this.state == null && this.transition == null ? 1 : 0) != 0, (String)"either state or transition must not be null");
        String resolvedType = this.state != null ? this.typeExtractor.determineType(variableName, (StateflowDeclContainerBase<?>)this.state) : this.typeExtractor.determineType(variableName, this.transition);
        if (resolvedType == null) {
            resolvedType = this.variableDataTypes.get(variableName);
            return Optional.ofNullable(resolvedType);
        }
        switch (resolvedType) {
            case "Inherit: From definition in chart": {
                this.localDefinedVariables.add(variableName);
                return Optional.empty();
            }
            case "Inherit: Same as Simulink": 
            case "Unknown": 
            case "NOT_CONNECTED": {
                return Optional.empty();
            }
        }
        return Optional.of(resolvedType);
    }

    private void deduceAssignmentType(MatlabActionAstNode astNode) {
        MatlabActionAstNode leftNode = astNode.getChildren().get(0);
        MatlabActionAstNode rightNode = astNode.getChildren().get(1);
        String dataType = this.astNodeDataTypes.getOrDefault(rightNode, "Unknown");
        if ("Unknown".equals(this.astNodeDataTypes.get(leftNode)) && !"Unknown".equals(dataType)) {
            this.astNodeDataTypes.put(leftNode, dataType);
        } else {
            this.astNodeDataTypes.putIfAbsent(leftNode, dataType);
        }
        this.astNodeDataTypes.put(astNode, dataType);
        String variableName = leftNode.getTokens().get(0).getText();
        if (this.localDefinedVariables.contains(variableName)) {
            this.variableDataTypes.put(variableName, dataType);
        } else {
            this.variableDataTypes.putIfAbsent(variableName, dataType);
        }
    }

    private void deduceBinaryOperatorDataTypes(MatlabActionAstNode astNode) {
        String rightDataType;
        String leftDataType;
        MatlabActionAstNode leftNode = astNode.getChildren().get(0);
        MatlabActionAstNode rightNode = astNode.getChildren().get(1);
        if (EMatlabActionEntityType.VARIABLE == leftNode.getType()) {
            this.assignUnresolvedDataTypeFromNodeToVariable(rightNode, leftNode);
        }
        if (EMatlabActionEntityType.VARIABLE == rightNode.getType()) {
            this.assignUnresolvedDataTypeFromNodeToVariable(leftNode, rightNode);
        }
        if ((leftDataType = this.astNodeDataTypes.getOrDefault(leftNode, "Unknown")).equals(rightDataType = this.astNodeDataTypes.getOrDefault(rightNode, "Unknown"))) {
            this.astNodeDataTypes.put(astNode, leftDataType);
        } else if (leftDataType.equals("Unknown") || rightDataType.equals("Unknown")) {
            this.astNodeDataTypes.put(astNode, "Unknown");
        } else {
            this.astNodeDataTypes.put(astNode, SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)CollectionUtils.asHashSet((Object[])new String[]{leftDataType, rightDataType})));
        }
    }

    private void deduceBooleanBinaryOperatorDataTypes(MatlabActionAstNode astNode) {
        String variableName;
        MatlabActionAstNode leftNode = astNode.getChildren().get(0);
        MatlabActionAstNode rightNode = astNode.getChildren().get(1);
        if (leftNode.getType() == EMatlabActionEntityType.VARIABLE) {
            variableName = leftNode.getTokens().get(0).getText();
            this.astNodeDataTypes.putIfAbsent(leftNode, this.variableDataTypes.getOrDefault(variableName, "Unknown"));
        }
        if (rightNode.getType() == EMatlabActionEntityType.VARIABLE) {
            variableName = rightNode.getTokens().get(0).getText();
            this.astNodeDataTypes.putIfAbsent(rightNode, this.variableDataTypes.getOrDefault(variableName, "Unknown"));
        }
        this.astNodeDataTypes.put(astNode, "boolean");
    }

    private void assignUnresolvedDataTypeFromNodeToVariable(MatlabActionAstNode fromNode, MatlabActionAstNode toVariable) {
        CCSMAssert.isTrue((EMatlabActionEntityType.VARIABLE == toVariable.getType() ? 1 : 0) != 0, (String)"toVariable is no variable node!");
        String variableName = toVariable.getTokens().get(0).getText();
        String dataType = this.variableDataTypes.getOrDefault(variableName, this.astNodeDataTypes.get(fromNode));
        if (dataType != null) {
            this.variableDataTypes.putIfAbsent(variableName, dataType);
            this.astNodeDataTypes.putIfAbsent(toVariable, dataType);
        }
    }

    private void deduceBoolOperationTypes(MatlabActionAstNode astNode) {
        MatlabActionAstNode leftNode = astNode.getChildren().get(0);
        if (EMatlabActionEntityType.VARIABLE == leftNode.getType()) {
            String variableName = leftNode.getTokens().get(0).getText();
            this.astNodeDataTypes.putIfAbsent(leftNode, this.variableDataTypes.getOrDefault(variableName, "boolean"));
        } else {
            this.astNodeDataTypes.putIfAbsent(leftNode, "boolean");
        }
        if (astNode.getChildren().size() > 1) {
            MatlabActionAstNode rightNode = astNode.getChildren().get(1);
            this.astNodeDataTypes.putIfAbsent(rightNode, "boolean");
        }
        this.astNodeDataTypes.put(astNode, "boolean");
    }

    private void deduceFunctionTypes(MatlabActionAstNode astNode) {
        this.deduceCastFunctionTypes(astNode);
        this.deduceLogicalFunctionTypes(astNode);
    }

    private void deduceCastFunctionTypes(MatlabActionAstNode astNode) {
        String expression;
        Matcher matcher;
        String functionName;
        HashSet<String> castOperations = new HashSet<String>(Arrays.asList("int8", "int16", "int32", "int64", "uint8", "uint16", "uint32", "uint64", "single", DEFAULT_NUMBER_TYPE, "char", "fi"));
        if (castOperations.contains(functionName = astNode.getTokens().get(0).getText())) {
            this.astNodeDataTypes.put(astNode, functionName);
        } else if (functionName.equals("cast") && (matcher = CAST_PATTERN.matcher(expression = TokenStreamTextUtils.concatTokenTexts(astNode.getTokens()))).matches()) {
            this.astNodeDataTypes.put(astNode, matcher.group(1));
        }
    }

    private void deduceLogicalFunctionTypes(MatlabActionAstNode astNode) {
        String functionName;
        HashSet<String> logicalOperations = new HashSet<String>(Arrays.asList("xor", "all", "any", "and", "or", "not", "islogical", "logical", "find", "true", "false"));
        if (logicalOperations.contains(functionName = astNode.getTokens().get(0).getText())) {
            this.astNodeDataTypes.put(astNode, "boolean");
        }
    }
}

