/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.IShallowParser;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jetbrains.annotations.VisibleForTesting;

public final class MatlabFunctionBlockCodeExtractionUtils {
    public static List<List<IToken>> extractMethodBodiesFromMatlabFunctionBlock(SimulinkBlock block) {
        Optional<StateflowState> stateflowState = MatlabFunctionBlockCodeExtractionUtils.extractStateflowStateFromMatlabFunctionBlock(block);
        if (!stateflowState.isPresent()) {
            return Collections.emptyList();
        }
        return MatlabFunctionBlockCodeExtractionUtils.extractMethodBodiesFromEmlScriptParameter(stateflowState.get());
    }

    public static List<List<IToken>> extractMethodBodiesFromEmlScriptParameter(StateflowState stateflowState) {
        IShallowParser shallowParser;
        String script = stateflowState.getParameter("eml.script");
        if (script == null || script.isEmpty()) {
            return Collections.emptyList();
        }
        script = StringUtils.unescapeChars((String)script, (Map)StringUtils.ESCAPE_NEWLINE);
        try {
            shallowParser = ShallowParserFactory.createParser(ELanguage.MATLAB);
        }
        catch (ShallowParserException e) {
            CCSMAssert.fail((String)"Found no MATLAB shallow parser");
            return null;
        }
        List<ShallowEntity> entities = shallowParser.parseTopLevel(ScannerUtils.getTokens(script, ELanguage.MATLAB, stateflowState.getMachine().getModel().getUniformPath()));
        ArrayList<List<IToken>> methodBodies = new ArrayList<List<IToken>>();
        ArrayList topLevelTokens = new ArrayList();
        for (ShallowEntity entity : entities) {
            if (entity.getType() == EShallowEntityType.METHOD) {
                methodBodies.addAll(MatlabFunctionBlockCodeExtractionUtils.extractMethodBodiesFromMethod(entity));
                continue;
            }
            topLevelTokens.addAll(entity.includedTokens());
        }
        if (!topLevelTokens.isEmpty()) {
            methodBodies.add(topLevelTokens);
        }
        return methodBodies;
    }

    public static Optional<StateflowState> extractStateflowStateFromMatlabFunctionBlock(SimulinkBlock block) {
        CCSMAssert.isTrue((boolean)StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)block), (String)"Function must be called for MatlabFunction blocks only.");
        return ((StateflowBlock)block).getChart().getNodes().stream().filter(node -> node instanceof StateflowState).map(state -> (StateflowState)state).findAny();
    }

    @VisibleForTesting
    static List<List<IToken>> extractMethodBodiesFromMethod(ShallowEntity methodEntity) {
        if (!methodEntity.hasChildren()) {
            return Collections.emptyList();
        }
        int childrenStartTokenIndex = ((ShallowEntity)methodEntity.getChildren().get(0)).getStartTokenIndex();
        int childrenEndTokenIndex = ((ShallowEntity)methodEntity.getChildren().get(methodEntity.getChildren().size() - 1)).getEndTokenIndex();
        ArrayList methodBodyTokens = new ArrayList(methodEntity.getAllTokensOfFile().subList(childrenStartTokenIndex, childrenEndTokenIndex));
        ArrayList<List<IToken>> methodBodies = new ArrayList<List<IToken>>();
        for (ShallowEntity nestedMethodEntity : methodEntity.getChildrenOfType(EShallowEntityType.METHOD)) {
            methodBodies.addAll(MatlabFunctionBlockCodeExtractionUtils.extractMethodBodiesFromMethod(nestedMethodEntity));
            methodBodyTokens.removeAll((Collection<?>)nestedMethodEntity.includedTokens());
        }
        methodBodies.add(methodBodyTokens);
        return methodBodies;
    }

    private MatlabFunctionBlockCodeExtractionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

