/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util.simulink;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public final class StateflowCheckUtils {
    private static final TokenPattern COMBINABLE_ACTIONS_ALTERNATIVE = new TokenPattern().alternative(TokenPattern.text("entry"), TokenPattern.text("en"), TokenPattern.text("exit"), TokenPattern.text("ex"), TokenPattern.text("during"), TokenPattern.text("du"));
    private static final TokenPattern COMBINABLE_STATE_ACTIONS_PATTERN = new TokenPattern().beginningOfStream().repeated(COMBINABLE_ACTIONS_ALTERNATIVE, ETokenType.COMMA).sequence(COMBINABLE_ACTIONS_ALTERNATIVE, ETokenType.COLON);
    private static final Set<String> PARAMETER_TOKEN_STATE_ACTIONS = CollectionUtils.asHashSet((Object[])new String[]{"after", "at", "before", "every"});

    public static List<StateflowStateAction> splitStateActionsFromStateLabel(StateflowState state) {
        String uniformPath = state.getMachine().getModel().getUniformPath();
        String stateActionLabelPart = StateflowUtils.extractStateActionsFromStateflowLabel((StateflowState)state);
        ELanguage language = ELanguage.MATLAB;
        if (StateflowUtils.hasActionLanguageC((StateflowChart)StateflowUtils.getChart((IStateflowElement)state))) {
            language = ELanguage.CPP;
        }
        List<IToken> tokens = ScannerUtils.getTokens(stateActionLabelPart, language, uniformPath);
        return StateflowCheckUtils.splitStateActionsFromStateflowStateLabelTokens(tokens);
    }

    @VisibleForTesting
    static @NonNull List<StateflowStateAction> splitStateActionsFromStateflowStateLabelTokens(List<IToken> tokens) {
        ArrayList<StateflowStateAction> stateActions = new ArrayList<StateflowStateAction>();
        List<IToken> currentActionDeclaration = Collections.emptyList();
        int currentTokenIndex = 0;
        while (currentTokenIndex < tokens.size()) {
            int endOfNextActionDeclaration;
            int nextActionDeclaration = TokenStreamUtils.findFirstTopLevelWithIndexPredicate(tokens, currentTokenIndex, index -> StateflowCheckUtils.isStateActionStartIndex(index, tokens), Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
            if (nextActionDeclaration == -1) {
                List<IToken> currentActions = tokens.subList(currentTokenIndex, tokens.size());
                stateActions.add(new StateflowStateAction(currentActionDeclaration, currentActions));
                return stateActions;
            }
            if (nextActionDeclaration > 0) {
                List<IToken> currentActions = tokens.subList(currentTokenIndex, nextActionDeclaration);
                stateActions.add(new StateflowStateAction(currentActionDeclaration, currentActions));
            }
            if ((endOfNextActionDeclaration = TokenStreamUtils.firstTokenMatching(tokens, nextActionDeclaration, (ITokenMatcher)ETokenType.COLON)) == -1) {
                return stateActions;
            }
            currentTokenIndex = endOfNextActionDeclaration + 1;
            currentActionDeclaration = tokens.subList(nextActionDeclaration, currentTokenIndex);
        }
        return stateActions;
    }

    private static boolean isStateActionStartIndex(Integer index, List<IToken> tokens) {
        if (index < 0 || index > tokens.size() - 2) {
            return false;
        }
        if (COMBINABLE_STATE_ACTIONS_PATTERN.matchAtStartOf(tokens.subList(index, tokens.size())) != null) {
            return true;
        }
        IToken currentToken = tokens.get(index);
        IToken nextToken = tokens.get(index + 1);
        if ("bind".equals(currentToken.getText()) && nextToken.getType() == ETokenType.COLON) {
            return true;
        }
        if (!currentToken.getText().equals("on") || index + 2 >= tokens.size()) {
            return false;
        }
        IToken nextNextToken = tokens.get(index + 2);
        if (nextToken.getType() == ETokenType.IDENTIFIER && nextNextToken.getType() == ETokenType.COLON) {
            return true;
        }
        if (index + 5 >= tokens.size()) {
            return false;
        }
        if (PARAMETER_TOKEN_STATE_ACTIONS.contains(nextToken.getText()) && nextNextToken.getType() == ETokenType.LPAREN) {
            int closingIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)index, ETokenType.LPAREN, ETokenType.RPAREN);
            return closingIndex != -1 && closingIndex + 1 < tokens.size() && tokens.get(closingIndex + 1).getType() == ETokenType.COLON;
        }
        return false;
    }

    public static StateflowTransitionParts splitTransitionLabel(StateflowTransition transition) {
        String label = transition.getLabel();
        if (label == null) {
            return StateflowTransitionParts.EMPTY_STATEFLOW_TRANSITION_PARTS;
        }
        String unescapedLabel = StringUtils.unescapeChars((String)label, (Map)StringUtils.ESCAPE_NEWLINE);
        String uniformPath = transition.accessChart().getMachine().getModel().getUniformPath();
        ELanguage language = ELanguage.MATLAB;
        if (StateflowUtils.hasActionLanguageC((StateflowChart)transition.accessChart())) {
            language = ELanguage.CPP;
        }
        return StateflowCheckUtils.splitStateflowTransitionTokens(unescapedLabel, uniformPath, language);
    }

    public static boolean isUnconditionalTransition(StateflowTransition transition) {
        return CollectionUtils.allMatch(StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition).condition, token -> token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT || token.getType().getTokenClass() == ETokenType.ETokenClass.WHITESPACE);
    }

    @VisibleForTesting
    static StateflowTransitionParts splitStateflowTransitionTokens(String label, String uniformPath, ELanguage language) {
        List<IToken> tokens = ScannerUtils.getTokens(label, language, uniformPath);
        int eventOrMessageEndIndex = TokenStreamUtils.endIndexIfNotFound(TokenStreamUtils.firstTokenMatching(tokens, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.LBRACK, ETokenType.MATRIX_RIGHT_DIV, ETokenType.DIV})), tokens);
        int conditionStartIndex = tokens.size();
        int conditionEndIndex = 0;
        int conditionActionStartIndex = tokens.size();
        int conditionActionEndIndex = 0;
        int transitionActionStartIndex = tokens.size();
        int transitionActionEndIndex = 0;
        int currentIndex = eventOrMessageEndIndex;
        block5: while (currentIndex < tokens.size()) {
            switch (tokens.get(currentIndex).getType()) {
                case LBRACK: {
                    conditionStartIndex = currentIndex + 1;
                    conditionEndIndex = TokenStreamUtils.endIndexIfNotFound(TokenStreamUtils.findMatchingClosingToken(tokens, conditionStartIndex, ETokenType.LBRACK, ETokenType.RBRACK), tokens);
                    currentIndex = conditionEndIndex + 1;
                    continue block5;
                }
                case LBRACE: {
                    conditionActionStartIndex = currentIndex + 1;
                    conditionActionEndIndex = TokenStreamUtils.endIndexIfNotFound(TokenStreamUtils.findMatchingClosingToken(tokens, conditionActionStartIndex, ETokenType.LBRACE, ETokenType.RBRACE), tokens);
                    currentIndex = conditionActionEndIndex + 1;
                    continue block5;
                }
                case DIV: 
                case MATRIX_RIGHT_DIV: {
                    transitionActionStartIndex = currentIndex + 1;
                    transitionActionEndIndex = tokens.size();
                    int braceIndex = TokenStreamUtils.firstTokenMatching(tokens, transitionActionStartIndex, (ITokenMatcher)ETokenType.LBRACE);
                    if (braceIndex != -1) {
                        transitionActionStartIndex = braceIndex + 1;
                        transitionActionEndIndex = TokenStreamUtils.endIndexIfNotFound(TokenStreamUtils.findMatchingClosingToken(tokens, transitionActionStartIndex, ETokenType.LBRACE, ETokenType.RBRACE), tokens);
                    }
                    currentIndex = tokens.size();
                    continue block5;
                }
            }
            currentIndex = TokenStreamUtils.endIndexIfNotFound(TokenStreamUtils.firstTokenMatching(tokens, currentIndex, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.LBRACK, ETokenType.MATRIX_RIGHT_DIV, ETokenType.DIV})), tokens);
        }
        return new StateflowTransitionParts(StateflowCheckUtils.rescanLabel(label, uniformPath, language, tokens, 0, eventOrMessageEndIndex), StateflowCheckUtils.rescanLabel(label, uniformPath, language, tokens, conditionStartIndex, conditionEndIndex), StateflowCheckUtils.rescanLabel(label, uniformPath, language, tokens, conditionActionStartIndex, conditionActionEndIndex), StateflowCheckUtils.rescanLabel(label, uniformPath, language, tokens, transitionActionStartIndex, transitionActionEndIndex));
    }

    private static List<IToken> rescanLabel(String label, String uniformPath, ELanguage language, List<IToken> tokens, int inclusiveStartIndex, int exclusiveEndIndex) {
        if (inclusiveStartIndex >= exclusiveEndIndex) {
            return Collections.emptyList();
        }
        int labelStartIndex = tokens.get(inclusiveStartIndex).getOffset();
        int labelEndIndex = tokens.get(exclusiveEndIndex - 1).getEndOffset() + 1;
        return ScannerUtils.getTokens(label.substring(labelStartIndex, labelEndIndex), language, uniformPath);
    }

    public static List<List<IToken>> splitLines(List<IToken> actionCode) {
        ArrayList<List<IToken>> lines = new ArrayList<List<IToken>>();
        int currentLineNumber = 0;
        ArrayList<IToken> currentLine = new ArrayList<IToken>();
        for (IToken token : actionCode) {
            if (token.getType() == ETokenType.EOL) continue;
            if (token.getLineNumber() > currentLineNumber) {
                if (!currentLine.isEmpty()) {
                    lines.add(currentLine);
                }
                currentLine = new ArrayList();
                currentLineNumber = token.getLineNumber();
            }
            currentLine.add(token);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    private StateflowCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

