This check detects `SELECT` statements that contain the `decode` function.

# Why is This a Problem?

The `decode` function is specific for Oracle and restricted to SQL.
Due to its appearance as function call it can additionally be hard to comprehend and, hence, could cause misuse.

Using the `CASE` function is more common, descriptive and not restricted to SQL since it can be used in PL/SQL as well.

# How Can I Resolve This?

Use the `CASE` instead of decode.

Note: `CASE` and `decode` handle `null` values differently (see examples). 

## Example (Before)

```oraclesqlplus

SELECT decode(foo,  'A',  1
                 , null, -1
                       ,  0)
  FROM bar;

```

## Example (After)

```oraclesqlplus
SELECT CASE
          WHEN foo = 'A'   THEN  1
          WHEN foo is null THEN -1
          ELSE 0
       END
  FROM bar;
```

# Where Can I Learn More?

## Guidelines
- [PL/SQL & SQL Coding Guidelines Version 4.0: G-4220: Try to use CASE rather than DECODE.](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.0/4-language-usage/4-control-structures/2-case-if-decode-nvl-nvl2-coalesce/g-4220/)
