Comments should be written with either ```//``` or ```/* */``` syntax consistently.

# Why is This a Problem?

Comments are vital to keeping the code readable.
To avoid confusion, it is important to use a consistent style in similar places. 

# How Can I Resolve This?

Use either ```//``` or ```/* */``` consistently.

## Example (Before)

```java
public class Main {
    /* This is a comment outside of a method. */
    // This is another comment outside of a method.
    public int fun() {
        // This is a comment inside of a method.
        /* This method prints out 'hello world'. */
        System.out.println("hello world");
    }
}
```

## Example (After)

```java
public class Main { 
    /* This is a comment outside of a method. */
    /* This is another comment outside of a method. */
    public int fun() {
        // This is a comment inside of a method.
        // This method prints out 'hello world'.
        System.out.println("hello world");
    }
}
```