This check detects usages of the preprocessor directives `#ifdef 0` or `#ifdef false` that aim to disable code.

# Why is This a Problem?
Using preprocessor directives to disable code make the code less readable and understandable.
Disabled code makes it hard for a reader to determine whether the code can be deleted or is just commented out temporarily.

# How Can I Resolve This?
In the context of version control systems, disabled or commented-out code should not be necessary.
Instead, delete the disabled code and use the version control system to restore the code if required. 
If unavoidable, use block comments to comment out the code.
This way, it is at least immediately visible that the code is commented out.

## Example (Before)

```c
int x = 3;
#ifdef 0
  int z = 5 + x;
  x = 0;
#endif
```

## Example (After)

```c
int x = 3;
```