The global namespace shall only contain `main`, `namespace` declarations and `extern "C"` declarations.

Placing declarations inside namespaces reduces the number of lookups for the compiler, reduces the probability of conflicting definitions during linking and makes the names more predictable and memorable for developers.

### Disallowed definitions that generate findings
```cpp
int	x;				// Variable in global namespace
int	y = 1;			// Variable in global namespace
AClass s;			// Class/Struct instance in global namespace
AClass i = {1,2};	// Class/Struct instance in global namespace

extern int	x = 1;			// Extern variable in global namespace
extern AClass	s = {1,2};	// Extern class/struct instance initialization in global namespace

extern const int	x = 1;		// Constant extern variable in global namespace
extern const AClass	s = {1,2};	// Constant extern class/struct instance initialization in global namespace

void 		foo() { ... }	// Function definition in global namespace
extern void	bar() { ... }	// Extern function definition in global namespace

class AClass { ... };	// Class definition in global namespace 
```
### Allowed definitions
```cpp										
namespace named_namespace {	// Namespace definition
	int	x;					// Variable inside namespace
	int	y = 1;				// Variable inside namespace
	extern const int z = 3;	// Extern variable inside namespace
	void foo() { ... }		// Function inside namespace
	class AClass { ... };	// Class definition inside namespace
}

namespace {				// Namespace definition							
	int x = 1;			// Variable inside namespace
	void bar() { ... }	// Function inside namespace
}

int32_t	main() { ... } 							// Main function in global namespace
int		main(int argc, char** argv) { ... } 	// Main function in global namespace
int		main(int argc, char* argv[]) { ... }	// Main function in global namespace

extern "C" int			x = 1;			// Extern "C" definition in global namespace
extern "C" const int	y = 1;			// Extern "C" definition in global namespace
extern "C" void			foo() { ... }	// Extern "C" definition in global namespace
```