Avoid checking objects for `None ` with `==` or `!=`  
`None` should not be compared with == or !=. Instead 'is' or 'is not' should be used.

# Why is This a Problem?
Classes are free to implement the equality operators in any way they want.  
Therefore, using the `==` or `!=` operator to check for `None` provides no guarantees.

# How Can I Resolve This?
Check for `None` using `is` or `is not`.

## Example (Before)

```python
if obj == None:
  ...
```

## Example (After)

```python
if obj is None:
   ...
```

## Additional Information
Performance-wise, `is` is also preferable over `==`.
