In Java, `this` can not be `null`.
Remove the comparison while preserving the programmer intention in another way.

# What Does This Check Look For?

This check creates a finding for comparisons of `this` and `null`.

# Why is This a Problem?

In Java, `this` can not be `null`. Therefore, the condition will always evaluate to the same value.
This indicates a programmer mistake and may also mislead others about the behavior of the code.

# How Can I Resolve This?

Remove the comparison of `this` and `null` while preserving the intentions of the condition.
For example. this may mean checking a member of the object instead of the object itself for `null`.

# Examples

## Non-Compliant

```java
public class Sample {
    public void doSomething() {
        if (this == null) { // non-compliant: 'this' cannot be null
            // handle supposedly uninitialized object
        }
    }
}
```

## Compliant

```java
public class Sample {
    private Object memberVariable;
    
    public void doSomething() {
        if (this.memberVariable == null) { // compliant: checks if member variable is not initialized
            // handle uninitialized member variable
        }
    }
}
```