Using parallel streams can lead to a significant overhead, thus their usage should be justified.
If not required, consider using sequential streams instead.

# What Does This Check Look For?

This check reports a finding when `Collection.parallelStream` or `Stream.parallel` is used without a corresponding comment providing a rationale or justification for the use of parallel streams.
The check looks for occurrences of a configurable regex pattern in comments close to the usage.
In the default configuration the regex is set to: `parallel|performance`

# Why is This a Problem?

Parallel streams introduce an overhead that can exceed 100 milliseconds.
When the operations processed by the stream are not substantial, this overhead can outweigh the benefits of using parallel streams.
Hence, it should be documented if the estimated operations are worth using parallel streams.

# How Can I Resolve This?

Provide documentation (or better: benchmarks or tests) that legitimize the usage of parallel streams.

# Examples
## Non-Compliant

```java
List<String> words = ...;
words.parallelStream() // non-compliant: no rationale for using parallelStream
.map(String::toLowerCase)
.forEach(System.out::println);
```

## Compliant

```java
List<String> words = ...;
// parallelStream is used to improve the performance on this very large list of words
words.parallelStream()    
.map(String::toLowerCase)
.forEach(System.out::println);
```

# Where Can I Learn More?

## References

- [Code Review Checklist (Java Concurrency): Item PS.1](https://github.com/code-review-checklists/java-concurrency#justify-parallel-stream-use)
- [Doug Lea on _When to use parallel streams_](http://gee.cs.oswego.edu/dl/html/StreamParallelGuidance.html)
