The code uses inline assembly along with other C/C++ statements.

# Why is This a Problem?

The use of inline assembly instructions degrade the portability of the code as they may only work for a specific platform.

# How Can I Resolve This?

Enclose the assembly code by a (inline) method, macro, or as an external assembly function.
This makes it easier to choose the correct instructions at runtime depending on the used platform.

## Example (Before)

```cpp
int main() {
    compute();
    asm("NOP");
    report();
    
    return 0;
}
```

## Example (After)

```cpp
void nop_x86() {
    asm("NOP");
}

int main() {
    compute();
    nop_x86();
    report();
    
    return 0;
}
```

# Where Can I Learn More?

## Guidelines

- MISRA C++2008, Rule 7–4–3: Assembly language shall be encapsulated and isolated
- AUTOSAR C++14, Rule A7-4-1: The `asm` declaration shall not be used