JUnit tests that are ignored or disabled might hide issues or decrease code coverage.
Regularly review and either fix or remove such tests.

# What Does This Check Look For?

This check flags any JUnit test annotations that signify a test is ignored or disabled.

# Why is This a Problem?

Ignoring or disabling tests can lead to unnoticed bugs and regressions because these tests are not executed, which makes
them ineffective. It reduces the reliability of the test suite and potentially leaves the software vulnerable to issues
that the tests were meant to catch. Additionally, it might indicate an underlying problem with the test or the code it's
testing, which requires attention.

# How Can I Resolve This?

Consider re-enabling ignored or disabled tests and addressing any issues that led to them being ignored in the first
place. If a test is no longer relevant or the code it tests has been removed, consider removing the test entirely. If
the test is flaky or non-deterministic, work on making it more reliable. In cases where tests are temporarily disabled
due to external dependencies or longer debugging processes, ensure they are re-enabled as soon as possible.

# Examples

## Non-Compliant

```java
import org.junit.Ignore;
import org.junit.Test;

public class MyTest {
	@Ignore
	@Test
	public void testSomething() {
		// This test will be ignored
	}
}
```

## Compliant

```java
import org.junit.Test;

public class MyTest {
	@Test
	public void testSomething() {
		// This test will not be ignored
	}
}
```