Unused fields are a form of dead code, which is undesirable since it adds unnecessary complexity
and increases the difficulty of understanding and maintaining the code base.
Unused fields, like any other dead code, should be removed.

# What Does This Check Look For?

This check detects unused private fields, i.e., fields that are never referenced in the code,
and reports them as findings.

# Why is This a Problem?

The presence of such fields can increase overall code complexity, which leads to code that is harder
to understand and modify, resulting in increased maintenance costs.
Additionally, they can indicate design issues, such as overly complex class hierarchies.
Unused fields can also hint at inconsistent or incomplete code refactorings,
where code that was previously referencing the field was removed, but the field itself was not.

# How Can I Resolve This?

If the fields are superfluous, they can be safely removed.
In case the functionality is still necessary but remains unused in the current implementation,
it may suggest the presence of a bug,
and, thus, the developers should consider modifying the code to incorporate the unused fields.

# Examples

## Non-Compliant

```java
public class Example {
    private int unusedField;   // non-compliant: This field is declared as private but is not used anywhere in the code.
    private int usedField;

    public Example(int usedField) {
        this.usedField = usedField;
    }

    public int getUsedField() {
        return usedField;
    }
}
```

## Compliant

```java
public class Example {
    private int usedField;

    public Example(int usedField) {
        this.usedField = usedField;
    }

    public int getUsedField() {
        return usedField;
    }
}
```

# Where Can I Learn More?

- [Clean Code: A Handbook of Agile Software Craftsmanship by Robert C. Martin](https://www.goodreads.com/book/show/3735293-clean-code)
- [Code Complete: A Practical Handbook of Software Construction, Second Edition by Steve McConnell](https://www.goodreads.com/book/show/4845.Code_Complete)