This check detects non-inline data declarations in ABAP statement blocks.

# Why is This a Problem?
In ABAP, data declarations are valid throughout the whole procedure (e.g., method, function module, or report). As a result, variables can be accessed at any procedure location independently of their declaration statement. This reduces the code's readability and makes it error-prone, especially for non-inline declarations within statement blocks.

# How Can I Resolve This?
Move non-inline declarations within statement blocks to locations before these blocks.

## Example (Before)

```ABAP
METHOD do_something.
  ...
  IF has_entries = abap_true.
    DATA value TYPE i.
    value = 1.
  ELSE.
    value = 2.
  ENDIF.
  ...
ENDMETHOD.
```

## Example (After)

``` ABAP
METHOD do_something.
  ...
  DATA value TYPE i.
  IF has_entries = abap_true.
    value = 1.
  ELSE.
    value = 2.
  ENDIF.
  ...
ENDMETHOD.
```

# Where Can I Learn More?

## Guidelines

- [SAP Clean ABAP guideline](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#variables)
- [ABAP Programming Guidelines - Inline Declaration](https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abendata_inline.htm)