Unnecessary use of `final` for parameters in abstract methods 
adds visual noise to the code and provides no functional advantage. 
Such parameters cannot be reassigned because the methods that declare them have no implementation. 
Removing `final` in these contexts helps keep code simpler and clearer.

# What Does This Check Look For?

This check detects the use of the final modifier in method parameters where it has no effect, 
specifically in methods with the `abstract` keyword and `interface` methods without a `default` implementation. 
Since these methods do not have a body, their parameters cannot be reassigned, 
making the use of `final` redundant and unnecessary.

# Why is This a Problem?

The `final` modifier is often used to prevent reassignment of parameters and improve clarity in method implementations. 
However, applying it to parameters of abstract methods serves no purpose. 
It adds clutter to the API and may mislead readers into thinking the modifier has specific relevance in that context.

Unnecessary modifiers can make code more verbose without providing additional meaning. 
Clean and minimal code is easier to read, reason about, and maintain.

# How Can I Resolve This?

Simply remove the `final` modifier from parameters in abstract methods.

# Examples

## Non-Compliant

```java
interface Processor {
    void process(final String input); // non-compliant: final has no effect here
}
```

```java
abstract class BaseService {
    public abstract void execute(final int count); // non-compliant: abstract method, final is redundant
}
```

## Compliant

```java
interface Processor {
    void process(String input); // compliant
}
```

```java
abstract class BaseService {
    public abstract void execute(int count); // compliant
}
```

# Where Can I Learn More?

- [Java Language Specification, §8.4.1](https://docs.oracle.com/javase/specs/jls/se9/html/jls-8.html#jls-8.4.1)
