Pragmas to suppress warnings from the Extended Program Check or the ABAP compiler should not be used as they can obscure potential code issues.
Instead, review and either address identified problems or flag the respective findings in Teamscale.

# What Does This Check Look For?
This check identifies instances where pragmas (e.g., `##needed`) are used in ABAP to suppress warnings in the code.

# Why is This a Problem?
Pragmas hide warnings which can lead to a false sense of security about the code's quality and functionality.
They might obscure issues that, if addressed, improve the maintainability and reliability of the software.
Future developers, or even the original author coming back to the code after some time, might find it difficult to understand why warnings were suppressed, complicating further maintenance or refactoring.

# How Can I Resolve This?
Instead of using pragmas to ignore warnings, examine each warning to determine if it indicates a real issue that should be addressed.
If the finding is considered invalid or not applicable, it should be flagged in Teamscale.
This approach ensures that all potential issues are either properly addressed or consciously acknowledged and documented.

# Examples
## Non-Compliant
```abap
DATA lv_unused TYPE i ##NEEDED.
WRITE: / 'This is an example.'.
```
## Compliant
Solving the underlying issue (by removing the unused variable in this case):
```abap
WRITE: / 'This is an example.'.
```

Removing the pragma, keeping the finding and, if applicable, flagging it as false positive in Teamscale:
```abap
DATA lv_unused TYPE i.
WRITE: / 'This is an example.'.
```