Importing types from the same package is unnecessary.
Instead, access types from the same package directly without importing them.

# What Does This Check Look For?

This check looks for import statements that reference types within the same package.

# Why is This Problematic?

Importing classes, interfaces, or other types from the same package can make the code more verbose and harder to understand.

# How Can I Resolve This?

Review the import statements in your code and remove any that refer to types within the same package.
Access these types directly, relying on the implicit package visibility that programming languages like Java provide.

# Examples

## Non-Compliant

```java
package com.example.mypackage;
import com.example.mypackage.MyClass; // non-compliant: importing type from the same package

public class MyOtherClass {
	// code utilizing MyClass
}
```

## Compliant

```java
package com.example.mypackage;
// Removed unnecessary import

public class MyOtherClass {
	// code utilizing MyClass is still valid without the import
}
```

# Where Can I Learn More?

- [Oracle Java Tutorials: Using Package Members](https://docs.oracle.com/javase/tutorial/java/package/usepkgs.html)