Control-flow statements without braces can be misinterpreted and can lead to serious errors.
Use braces for clarity.

# What Does This Check Look For?

This check detects statement blocks in loops and conditional statements that are not enclosed in braces - `{` and `}`.

# Why is This a Problem?

While many languages allow omitting braces around one line statements, this practice is discouraged because it can lead to serious errors.
In particular, one may accidentally add a statement intended to run as part of the loop or conditional statement, that is in fact executed outside of it.

A commonly known example is Apple's `goto fail` bug, prompting also other software vendors to address this issue (see references).

## Example

When adding a function call to a loop like this:
``` js
while (more_to_do) 
    doStuff();
```
It is very easy to change it to:
``` js
while (more_to_do) 
    doStuff();
    doOtherStuff();
```
Now, it looks like `doOtherStuff()` is part of the loop, but it is actually not and will only be called once after the loop has finished.

The same problem applies for if-statements like this:
``` js
if (more_to_do) 
    doStuff();
    doOtherStuff();
```
Here, it looks like `doOtherStuff()` will only be executed when the condition `more_to_do` holds, but it will always be called as it is not in the scope of the if-statement.

# How Can I Resolve This?

Using braces at all times can prevent something like this to happen.

# Examples
## Non-Compliant

``` js
if (condition)
    // some code
    
while (condition)
    // some code
```

## Compliant

``` js
if (condition) {
    // some code
}

while (condition) {
    // some code
}
```

# Where Can I Learn More?

* Guideline: MISRA C:2012, 15.6 - The body of an iteration-statement or a selection-statement shall be a compound-statement
* Guideline: AUTOSAR C++14, M6-3-1 - The statement forming the body of a switch, while, do ... while or for statement shall be a compound statement
* [National Vulnerability Database: CVE-2014-1266 - Vulnerability details for Apple's goto fail bug](https://nvd.nist.gov/vuln/detail/CVE-2014-1266)
* [Mozilla Bugtracker: Bug 1375220 - Ensure all if-else statements have curly braces](https://bugzilla.mozilla.org/show_bug.cgi?id=1375220)
