The throwing of too generic exceptions should be avoided, this check finds all occurrences of this behaviour.

# Why is This a Problem?
Using generic exceptions such as `Error`, `RuntimeException`, 
`Throwable`, and `Exception` prevents calling methods from handling true, 
system-generated exceptions differently than application-generated errors.

# How Can I Resolve This?
Create custom exception classes or use more specific exception classes from the standard library.


## Example (Before)
```kotlin
fun badExample(input: Int): Int {
    if (input == 0) {
        throw Exception("Input cannot be 0")
    }
    return 42
}

```

## Example (After)
```kotlin
fun better(input: Int): Int {
    if (input == 0) {
        throw IllegalArgumentException("Input cannot be 0")
    }
    return 42
}
```

# Where Can I Learn More?

## References
- https://rules.sonarsource.com/java/RSPEC-112
- https://dzone.com/articles/java-top-5-exception-handling
- https://stackify.com/common-mistakes-handling-java-exception/

