This check detects the use of exception raising statements such as `throw` and `raise` within `finally` blocks.

# Why is This a Problem?

If an exception is thrown within a `finally` block, an in-progress exception that was (re-)thrown earlier (in `try`
or `catch` blocks) may be masked since the one thrown in the `finally` block takes precedence.

# How Can I Resolve This?

Avoid throwing exceptions within `finally` blocks.

## Example (Java)

```java
try {
    try {
        throw new RuntimeException("exception-1");
    }
    finally {
        throw new RuntimeException("exception-finally");  // masks earlier exception-1
    }
}
catch(Exception e) {
    System.out.println(e.getMessage());  // prints: exception-finally
}
```

## Example (Objective-C)

```objective-c
@try {
    foo();
}
@catch(id ex) {
    bar();
}
@finally {
    id ex1;
    @throw ex1;                              // throws an exception, may mask other exceptions
    NSException *ex2 = [NSException new];
    [ex2 raise];                             // throws an exception, may mask other exceptions
}
```

## References

- [Java Language Specification: Execution of try-finally and try-catch-finally](https://docs.oracle.com/javase/specs/jls/se17/html/jls-14.html#jls-14.20.2)
- [C# Specification: The throw statement](https://docs.microsoft.com/en-us/dotnet/csharp/language-reference/language-specification/statements#12106-the-throw-statement)
- [Apple Documentation: Handling Exceptions](https://developer.apple.com/library/archive/documentation/Cocoa/Conceptual/Exceptions/Tasks/HandlingExceptions.html#//apple_ref/doc/uid/20000059-SW1)