Defining variables that are never used can make the code harder to read and understand. 
Instead, define variables only if they are actually needed.

# What Does This Check Look For?
This check reports a finding when a variable is declared inside the program but not referred or used anywhere in the scope of the program.

# Why is This a Problem?
Unused variables can be a source of confusion for developers as they try to understand the code. 
Seeing a variable declared but unused leads to questions about whether it is a left-over from previous versions of the code, or if it's a mistake and was supposed to be used somewhere. 
This can waste developer time as they dig into history or run tests to find out. 
In some extreme cases, it might lead to erroneous future code modifications.

# How Can I Resolve This?
Unused variables should be removed to streamline code reading and comprehension. 
Before doing so, you should carefully check whether the variable was intended for use, and if so, why it ended up not being used.

# Examples
## Non-Compliant

```oraclesqlplus
DECLARE
  v_unused_variable NUMBER; -- non-compliant: variable declared but not used
BEGIN
  DBMS_OUTPUT.PUT_LINE('Hello, World!');
END;
```

## Compliant

```oraclesqlplus
BEGIN
  DBMS_OUTPUT.PUT_LINE('Hello, World!');
END;
```

# Where Can I Learn More?
- [G-1030: Avoid defining variables that are not used](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.2/4-language-usage/1-general/g-1030/)
