Creating clear and unambiguous specification items enhances comprehension and reduces the risk of misinterpretation. 
It is recommended to avoid the use of the oblique "/" symbol except in units like Km/hr, and to avoid parentheses and brackets containing subordinate text.

# What Does This Check Look For?

This check searches for instances where fields in items utilize certain specified symbols. Some use cases of these symbols that should not be checked for are added to the check as "exceptions".

# Why is This a Problem?

An example of a symbol that should be avoided is the oblique "/" symbol. It could be interpreted in several ways depending on context, including division, alternatives, or a variety of other meanings, which can lead to misunderstandings within specification items.
Another example is the use of parentheses and brackets to contain subordinate text. This may obscure important information, resulting in a lower level of clarity within a specification.

# How Can I Resolve This?

Developers can address this obstacle by refraining from using the oblique "/" symbol except in units.
Instead, use words that explicitly state the intended meaning, such as "per", "and", "or". 
Also, rather than using parentheses and brackets for subordinate text, consider splitting complex sentences into simpler ones or restructuring for directness.

# Examples

## Non-Compliant

```markdown
# Social Media Integration Requirement
Type: Requirement
Description: Implement a feature that allows users to sign in using their Google/Facebook/Twitter account (depending on their preference) with a button on the website's homepage.
// non-compliant: the oblique symbol is used, and brackets contain subordinate text.
```

## Compliant
 
```markdown
# Social Media Integration Requirement
Type: Requirement
Description: Implement a feature that permits users to sign in using their preferred social media accounts such as Google, Facebook, or Twitter. 
This feature requires a button on the website's homepage.
// compliant: the oblique symbol is not used, and the sentence has been restructured to eliminate using brackets for subordinate text.
```

# Where Can I Learn More?

- Guideline: INCOSE R17 - Avoid the use of the oblique ("/") symbol except in units.
- Guideline: INCOSE R21 - Avoid parentheses and brackets containing subordinate text.
- Learn more from [INCOSE R17, INCOSE R21 Reference](https://www.incose.org/docs/default-source/working-groups/requirements-wg/rwg_products/incose_rwg_gtwr_summary_sheet_2022.pdf?sfvrsn=a95a6fc7_2)