Index signals shall be of type integer or enum.

To prevent unexpected results that can occur with rounding errors for floating-point data types, the data type of index signals shall be an integer or enum.

This check inspects index signals going into the following blocks*:

- Assignment
- Direct Lookup Table (n-D)
- Index Vector
- Interpolation Using Prelookup
- Multiport Switch
- Selector
- Stateflow charts*

_* Note: This check does not consider signals going into MATLAB function blocks or Stateflow charts with MATLAB action language, since we cannot determine which inputs are used as index variables._

## Guidelines

- [High-Integrity Modeling Guideline](https://mathworks.com/help/simulink/mdl_gd/hi/signal-routing.html#bsljqf7-3)

## References

- Corresponding Model Advisor check [HISM hisl_0022](https://www.mathworks.com/help/slcheck/ref/check-data-types-for-blocks-with-index-signals.html)
