<h2>Why is this an issue?</h2>
<p>Spring Expression Language (SpEL) is an expression language used in the Spring Framework for evaluating and manipulating objects, properties, and
conditions within Spring-based applications.</p>
<p><code>org.springframework.ui.Model</code> is an interface in the Spring Framework that represents a container for data that can be passed between a
controller and a view in a Spring MVC web application, allowing for data sharing during the request-response cycle.</p>
<p>Attributes added to the <code>org.springframework.ui.Model</code> should follow the Java identifier naming convention, which means they must start
with a letter <code>a-z, A-Z</code>, underscore <code>_</code>, or a dollar sign <code>$</code> and may be followed by letters, digits, underscores,
or dollar signs.</p>
<p>Failure to do so may result in SpEL parsing errors when using these attributes in template engines.</p>
<h2>How to fix it</h2>
<p>Follow the Java identifier naming convention.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
model.addAttribute(" a", 100); // Noncompliant (starts with a space)
model.addAttribute("a-b", 7);  // Noncompliant (contains a hyphen)
model.addAttribute("1c", 42);  // Noncompliant (starts with a digit)
```
<h4>Compliant solution</h4>

```java
model.addAttribute("a", 100);
model.addAttribute("b", 42);
model.addAttribute("_c", 7);
model.addAttribute("$d", 8);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.oracle.com/java/technologies/javase/codeconventions-namingconventions.html">Java SE - naming conventions</a> </li>
  <li> <a href="https://docs.spring.io/spring-framework/reference/core/expressions.html">Spring Expression Language (SpEL)</a> </li>
  <li> <a href="https://docs.spring.io/spring-framework/docs/current/javadoc-api/org/springframework/ui/Model.html">Spring IO Docs - Interface
  Model</a> </li>
</ul>