import{_ as i,c as e,ak as a,o as t}from"./chunks/framework.AfHpRKMk.js";const d=JSON.parse('{"title":"Accessing Teamscale via HTTPS","description":"","frontmatter":{"title":"Accessing Teamscale via HTTPS"},"headers":[],"relativePath":"howto/configuring-https/index.md","filePath":"howto/configuring-https/index.md"}'),n={name:"howto/configuring-https/index.md"};function h(l,s,r,p,o,k){return t(),e("div",null,[...s[0]||(s[0]=[a(`<h1 id="how-to-configure-https-tls-ssl-access-to-the-teamscale-server" tabindex="-1">How to Configure HTTPS (TLS/SSL) Access to the Teamscale Server <a class="header-anchor" href="#how-to-configure-https-tls-ssl-access-to-the-teamscale-server" aria-label="Permalink to &quot;How to Configure HTTPS (TLS/SSL) Access to the Teamscale Server&quot;">​</a></h1><p>Teamscale can optionally provide HTTPS access to the Teamscale Server, either in addition to HTTP or exclusively. The enablement of both can be controlled via the settings <code>server.port</code> and <code>https.port</code> in the <a href="./../../reference/administration-ts-installation/">server configuration</a>.</p><div class="tip custom-block"><p class="custom-block-title">HTTPS-Termination using a Reverse Proxy</p><p>Instead of configuring Teamscale itself to terminate the HTTPS connection, a reverse proxy like NGINX or Apache can be used instead.</p><p>Depending on the environment the configuration of a reverse proxy may be <strong>easier</strong> and <strong>less error-prone</strong>. Please refer to this documentation page: <a href="./../configuring-reverse-proxy/">How to Integrate with Apache Webserver or NGINX</a></p></div><div class="tip custom-block"><p class="custom-block-title">Connecting to External Servers via HTTPS</p><p>How to access external servers (e.g., GitLab or Jira) that allow only HTTPS communication from Teamscale is described in a different documentation page: <a href="./../connecting-via-https/">Connecting to External Servers via HTTPS</a></p></div><nav class="table-of-contents"><ul><li><a href="#ssl-keys-and-certificate">SSL Keys and Certificate</a></li><li><a href="#converting-certificate-to-pkcs-12-format">Converting Certificate to PKCS 12 Format</a></li><li><a href="#creating-a-keystore">Creating a Keystore</a></li><li><a href="#adapting-teamscale-properties">Adapting teamscale.properties</a></li><li><a href="#shell-script-for-generation-of-a-keystore">Shell Script for Generation of a Keystore</a></li></ul></nav><h2 id="ssl-keys-and-certificate" tabindex="-1">SSL Keys and Certificate <a class="header-anchor" href="#ssl-keys-and-certificate" aria-label="Permalink to &quot;SSL Keys and Certificate&quot;">​</a></h2><p>To set up HTTPS communication for Teamscale, a pair of private key and certificate is required. Your company may already have a certificate and key available or a new pair has to be generated. Please consult your IT operations team for potential regulations in your company. Technically, you also have the option of generating a self-signed certificate (not recommended for security reasons).</p><p>Teamscale requires the private key and certificate to be stored in the Java Keystore format (<code>.jks</code>). Prior to importing a certificate in a Java keystore, the certificate has to be converted to the PKCS 12 format.</p><h2 id="converting-certificate-to-pkcs-12-format" tabindex="-1">Converting Certificate to PKCS 12 Format <a class="header-anchor" href="#converting-certificate-to-pkcs-12-format" aria-label="Permalink to &quot;Converting Certificate to PKCS 12 Format&quot;">​</a></h2><div class="tip custom-block"><p class="custom-block-title">Conversion under Windows</p><p>In case you are using Windows and have the certificate stored in the <em>Certificate Management</em> of the operating system, you can directly export the certificate and private key in the PKCS 12 format using the <em>Certificate Export Wizard</em>. You can then skip the conversion in the next paragraph and continue with the creation of the Java keystore.</p></div><p>In case the certificate and key was created with OpenSSL, the conversion can be done using the <a href="https://www.openssl.org" target="_blank" rel="noreferrer">OpenSSL command line tool</a>. When working on Windows, note that OpenSSL comes per default with the <a href="https://gitforwindows.org/" target="_blank" rel="noreferrer">Git Bash for Windows</a>.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>If your certificate comes as <code>.pfx</code> file, simply renaming to <code>.p12</code> can work. You can then continue and <a href="#creating-a-keystore">create a keystore</a>.</p></div><p>Assuming your certificate is available in a file <code>myhost.crt</code> and your private key in a file <code>myhost.key</code> , the following command will combine them and save them a file <code>myhost.p12</code> converting them to the PKCS12 format which is compatible with the Java keystore (you will be asked for an export password):</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">openssl</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pkcs12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -export</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -in</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> myhost.crt</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -inkey</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> myhost.key</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -out</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> myhost.p12</span></span></code></pre></div><h2 id="creating-a-keystore" tabindex="-1">Creating a Keystore <a class="header-anchor" href="#creating-a-keystore" aria-label="Permalink to &quot;Creating a Keystore&quot;">​</a></h2><p>After this, you can create a new Java keystore and import the certificate/key pair into the newly created store. This can be done with the <code>keytool</code> command line tool that is part of Java (located in the <code>bin</code> folder of the Java installation). The following command will create a new file <code>myhost.jks</code> containing a Java keystore with both the certificate and private key. You will be asked for import and export passwords.</p><div class="warning custom-block"><p class="custom-block-title">Use same Password</p><p>Please ensure to use the same password used previously for protecting the private key also for the keystore.</p></div><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">keytool</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -importkeystore</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -srckeystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> myhost.p12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -srcstoretype</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pkcs12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -destkeystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> myhost.jks</span></span></code></pre></div><div class="warning custom-block"><p class="custom-block-title">Use same Java version</p><p>Please ensure to use the same Java version for creating the keystore and running Teamscale. Otherwise, Teamscale may be not able to read the provided keystore, which will result in a failure during startup.</p></div><h2 id="adapting-teamscale-properties" tabindex="-1">Adapting <code>teamscale.properties</code> <a class="header-anchor" href="#adapting-teamscale-properties" aria-label="Permalink to &quot;Adapting \`teamscale.properties\`&quot;">​</a></h2><p>To enable HTTPS for Teamscale, all configuration settings in <code>teamscale.properties</code> starting with <code>https.</code> have to be <a href="./../../reference/administration-ts-installation/#primary-settings-teamscale-properties">properly configured</a>. Make sure to properly configure the path to the newly generated Java keystore, its password as well as the certificate alias.</p><p>If you do not know the alias of your certificate, you can look it up with a <code>keytool</code> command:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">keytool</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -list</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -keystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> myhost.jks</span></span></code></pre></div><p>If everything was properly configured, Teamscale will accept HTTPS connections on the HTTPS port specified in the Teamscale settings (<code>https.port</code>). All connections to the configured HTTP port (the value for <code>server.port</code> or the default of 8080) will be forwarded to the HTTPS port. If the HTTP port is set to 0, HTTP is disabled and only HTTPS connections are accepted.</p><h2 id="shell-script-for-generation-of-a-keystore" tabindex="-1">Shell Script for Generation of a Keystore <a class="header-anchor" href="#shell-script-for-generation-of-a-keystore" aria-label="Permalink to &quot;Shell Script for Generation of a Keystore&quot;">​</a></h2><p>This is a shell script (Bash script) that executes the steps described on this page. On Windows systems, it can be executed in the <a href="https://gitforwindows.org/" target="_blank" rel="noreferrer">Git Bash for Windows</a>. It furthermore requires that the Java <code>keytool</code> executable is available (the <code>keytool</code> is part of the Java Runtime Environment JRE).</p><p>Please note that the script needs to be adapted before using it: the names of the input files have to be changed.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">#! /bin/bash</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># TODO: input certificate file. This will be the certificate that the Teamscale server uses to identify itself.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># For example, if Teamscale is accessed via the URL teamscale.company.org, then this must be the certificate for teamscale.company.org .</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">CERT_FILE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">MyTeamscaleServer.crt</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># TODO: private key file for the input certificate.</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">CERT_KEY_FILE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">MyTeamscaleServer.key</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Password of the entry in the new keystore (has to be set in Teamscale config file)</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">STORE_PASSWORD</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">12345678</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Alias of the entry in the new keystore</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">CERT_ALIAS</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">teamscalehostcert</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">if</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> [ </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">-f</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> keystore.jks ]; </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">then</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Found a keystore.jks file. Please remove it before starting this script (we will generate this keystore).&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Aborting.&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    exit</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 1</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">fi</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Generate a new intermediate.p12 certificate in pkcs12 format. This contains the certificate AND the private key</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># N.B.: You may run into issues with this, if you do not have enough permissions such that openssl can access some system files.</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">openssl</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pkcs12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -export</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -in</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> $CERT_FILE </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">-inkey</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> $CERT_KEY_FILE </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">-out</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> intermediate.p12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -passout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pass:</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$STORE_PASSWORD </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">-name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> $CERT_ALIAS</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Import the certificate (with private key) into a new Java keystore</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">keytool</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -importkeystore</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -srckeystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> intermediate.p12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -srcstorepass</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> $storePassword </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">-srcstoretype</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pkcs12</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -destkeystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> keystore.jks</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -deststorepass</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> $STORE_PASSWORD </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">-deststoretype</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pkcs12</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># List the contents of the new keystore</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">keytool</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -list</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -keystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> keystore.jks</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -storepass</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> $STORE_PASSWORD</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Determine the path of the new keystore file</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">if</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> hash</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> cygpath</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> 2&gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">/dev/null</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">; </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">then</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # Assume that this is a Windows system (running in Cygwin/Git bash here)</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    ABSOLUTE_PATH_TO_KEYSTORE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">cygpath</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -w</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --absolute</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> keystore.jks)&quot;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">else</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # Assume that this is a real Unix system</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    ABSOLUTE_PATH_TO_KEYSTORE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;$(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">pwd</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">)/keystore.jks&quot;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">fi</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Set the following properties in the file config/teamscale.properties in your Teamscale installation:&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;https.port=443&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;https.keystore-path=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$ABSOLUTE_PATH_TO_KEYSTORE</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;https.keystore-password=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$STORE_PASSWORD</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;https.certificate-alias=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$CERT_ALIAS</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Optionally, you can set server.port=0 to disable HTTP access.&quot;</span></span></code></pre></div>`,28)])])}const y=i(n,[["render",h]]);export{d as __pageData,y as default};
