import{_ as c,c as p,ak as n,b as e,O as t,x as i,z as s,L as d,o as h}from"./chunks/framework.AfHpRKMk.js";const y=JSON.parse('{"title":"Teamscale CLI for Build (teamscale-build)","description":"","frontmatter":{"title":"Teamscale CLI for Build (`teamscale-build`)","pageClass":"wider-content"},"headers":[],"relativePath":"reference/cli/teamscale-build/index.md","filePath":"reference/cli/teamscale-build/index.md"}'),m={name:"reference/cli/teamscale-build/index.md"};function u(g,a,k,f,b,v){const r=d("FileDownload"),o=d("PluginTabsTab"),l=d("PluginTabs");return h(),p("div",null,[a[27]||(a[27]=n('<h1 id="command-line-client-for-build-teamscale-build" tabindex="-1">Command-Line Client for Build (<code>teamscale-build</code>) <a class="header-anchor" href="#command-line-client-for-build-teamscale-build" aria-label="Permalink to &quot;Command-Line Client for Build (`teamscale-build`)&quot;">​</a></h1><p><code>teamscale-build</code> is a native command-line tool that supports typical use cases as faced on continuous integration servers and in CI/CD pipelines. The tool currently supports:</p><ul><li>compressing coverage reports from <a href="#input-coverage-format">common formats</a> to a single compact Teamscale-specific report. This reduces the database size of Teamscale, the size of Teamscale backups and improves analysis performance.</li><li>converting multiple test-specific coverage reports to a single <a href="./../../upload-formats-and-samples/testwise-coverage/">Testwise Coverage</a> report. This is useful if your tooling can produce one coverage report per test case but not our custom Testwise Coverage JSON format.</li></ul><div class="tip custom-block"><p class="custom-block-title">How-To Guide</p><p>Our <a href="./../../../tutorial/generating-testwise-coverage/">Tutorial</a> describes how to use this tool in practice with a simple example.</p></div><h2 id="download" tabindex="-1">Download <a class="header-anchor" href="#download" aria-label="Permalink to &quot;Download&quot;">​</a></h2><p>You can download the latest version here (<a href="https://downloads.teamscale.com/tools/teamscale-build/latest/CHANGELOG.md" target="_blank" rel="noreferrer">Changelog</a>):</p>',6)),e("ul",null,[e("li",null,[t(r,{icon:"file archive",title:"teamscale-build for Linux x86_64",link:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-linux-amd64.zip"}),a[0]||(a[0]=i(" (",-1)),a[1]||(a[1]=e("a",{href:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-linux-amd64.zip.sha256",target:"_blank",rel:"noreferrer"},"SHA256 checksum",-1)),a[2]||(a[2]=i(")",-1))]),e("li",null,[t(r,{icon:"file archive",title:"teamscale-build for Windows x86_64",link:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-windows-amd64.zip"}),a[3]||(a[3]=i(" (",-1)),a[4]||(a[4]=e("a",{href:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-windows-amd64.zip.sha256",target:"_blank",rel:"noreferrer"},"SHA256 checksum",-1)),a[5]||(a[5]=i(")",-1))]),e("li",null,[t(r,{icon:"file archive",title:"teamscale-build for macOS aarch64",link:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-macos-aarch64.zip"}),a[6]||(a[6]=i(" (",-1)),a[7]||(a[7]=e("a",{href:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-macos-aarch64.zip.sha256",target:"_blank",rel:"noreferrer"},"SHA256 checksum",-1)),a[8]||(a[8]=i(")",-1))]),e("li",null,[t(r,{icon:"file archive",title:"teamscale-build for macOS x86_64",link:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-macos-x86_64.zip"}),a[9]||(a[9]=i(" (",-1)),a[10]||(a[10]=e("a",{href:"https://downloads.teamscale.com/tools/teamscale-build/latest/teamscale-build-macos-x86_64.zip.sha256",target:"_blank",rel:"noreferrer"},"SHA256 checksum",-1)),a[11]||(a[11]=i(")",-1))])]),a[28]||(a[28]=e("p",null,[i("Then extract the zip file and place it in a folder where your shell can pick it up (somewhere on your "),e("code",null,"PATH"),i(").")],-1)),a[29]||(a[29]=e("p",null,[i("On macOS you will additionally need to run "),e("code",null,"sudo xattr -d com.apple.quarantine teamscale-build"),i(" to tell Gatekeeper that it may allow to execute the binary.")],-1)),a[30]||(a[30]=e("p",null,[i("The command-line client exposes its functionality as a set of commands. You can use the built-in help option, "),e("code",null,"--help"),i(", to list all available commands.")],-1)),t(l,{sharedStateKey:"os"},{default:s(()=>[t(o,{label:"Linux"},{default:s(()=>[...a[12]||(a[12]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])]),_:1}),t(o,{label:"Windows"},{default:s(()=>[...a[13]||(a[13]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-build.exe --help")])])])],-1)])]),_:1}),t(o,{label:"macOS"},{default:s(()=>[...a[14]||(a[14]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])]),_:1})]),_:1}),a[31]||(a[31]=e("p",null,[i("The various commands can be further configured by command-line options. In particular, you can use the help option, "),e("code",null,"--help"),i(", built into all commands to list their respective options. For example:")],-1)),t(l,{sharedStateKey:"os"},{default:s(()=>[t(o,{label:"Linux"},{default:s(()=>[...a[15]||(a[15]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])]),_:1}),t(o,{label:"Windows"},{default:s(()=>[...a[16]||(a[16]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-build.exe coverage testwise --help")])])])],-1)])]),_:1}),t(o,{label:"macOS"},{default:s(()=>[...a[17]||(a[17]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])]),_:1})]),_:1}),a[32]||(a[32]=n('<p>Many options are <a href="#common-options">common</a>, while others are specific to a command and explained in the following alongside their respective command.</p><h2 id="the-coverage-compact-command" tabindex="-1">The <code>coverage compact</code> command <a class="header-anchor" href="#the-coverage-compact-command" aria-label="Permalink to &quot;The `coverage compact` command&quot;">​</a></h2><p>The <code>coverage compact</code> command converts multiple coverage reports of one format to a single Teamscale Compact coverage report. This format is a Teamscale-specific coverage format that allows to upload coverage information in a compressed format to reduce the amount of data processed by the Teamscale instance. If you are unfamiliar with the Compact coverage format, you might want to read the <a href="./../../upload-formats-and-samples/teamscale-compact-coverage/">specification</a> first. An example of the command would be:</p>',3)),t(l,{sharedStateKey:"os"},{default:s(()=>[t(o,{label:"Linux"},{default:s(()=>[...a[18]||(a[18]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," compact"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/project"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/compact-coverage.json"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -f"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," JACOCO")])])])],-1)])]),_:1}),t(o,{label:"Windows"},{default:s(()=>[...a[19]||(a[19]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-build.exe coverage "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"compact"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," -i C:\\project -o C:\\tmp\\compact-coverage.json -f JACOCO")])])])],-1)])]),_:1}),t(o,{label:"macOS"},{default:s(()=>[...a[20]||(a[20]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," compact"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/project"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/testwise-coverage.json"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -f"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," JACOCO")])])])],-1)])]),_:1})]),_:1}),a[33]||(a[33]=n('<h3 id="command-specific-options" tabindex="-1">Command-specific options <a class="header-anchor" href="#command-specific-options" aria-label="Permalink to &quot;Command-specific options&quot;">​</a></h3><p>There exists the following command-specific option:</p><ul><li><code>-f</code> or <code>--format</code> The coverage format, must be one of the <a href="#input-coverage-format">supported formats</a>.</li><li><code>-u</code>/<code>--include-uncovered-lines</code> (optional): Flag if uncovered lines should be included in the output. This is only relevant information for preprocessor languages like C/C++/C#. Default is false. You will have to enable the feature toggle <code>-Dcom.teamscale.feature-toggle.use-coverable-lines-from-coverage-reports=true</code> on your Teamscale instance to let Teamscale make use of this data. By default, Teamscale will ignore that information and determine the coverable lines heuristically.</li></ul><h2 id="the-coverage-testwise-command" tabindex="-1">The <code>coverage testwise</code> command <a class="header-anchor" href="#the-coverage-testwise-command" aria-label="Permalink to &quot;The `coverage testwise` command&quot;">​</a></h2><p>The <code>coverage testwise</code> command converts multiple coverage reports of one format to a single Teamscale Testwise Coverage report. If you are unfamiliar with the Testwise Coverage format, you might want to read the <a href="./../../upload-formats-and-samples/testwise-coverage/">specification</a> first. An example of the command would be:</p>',5)),t(l,{sharedStateKey:"os"},{default:s(()=>[t(o,{label:"Linux"},{default:s(()=>[...a[21]||(a[21]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/project"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/testwise-coverage.json")])])])],-1)])]),_:1}),t(o,{label:"Windows"},{default:s(()=>[...a[22]||(a[22]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-build.exe coverage testwise -i C:\\project -o C:\\tmp\\testwise-coverage.json")])])])],-1)])]),_:1}),t(o,{label:"macOS"},{default:s(()=>[...a[23]||(a[23]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/project"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/testwise-coverage.json")])])])],-1)])]),_:1})]),_:1}),a[34]||(a[34]=n(`<p>This scans the given directory recursively for <code>metadata.json</code> files that point to the coverage files that should be processed, and outputs a merged Testwise Coverage report to the given json file.</p><h3 id="input-path-structure" tabindex="-1">Input path structure <a class="header-anchor" href="#input-path-structure" aria-label="Permalink to &quot;Input path structure&quot;">​</a></h3><p>The provided input paths (given via <code>-i</code>) will be traversed recursively for files named <code>metadata.json</code>. This <code>metadata.json</code> is expected to contain a <code>testInfo</code> object with the test&#39;s path, duration and result. A <code>metadata.json</code> might look like this:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>{ &quot;testInfo&quot;: </span></span>
<span class="line"><span>  {</span></span>
<span class="line"><span>    &quot;uniformPath&quot;: &quot;my/cool/Test1&quot;, </span></span>
<span class="line"><span>    &quot;result&quot;: &quot;PASSED&quot;,</span></span>
<span class="line"><span>    &quot;duration&quot;: 1 </span></span>
<span class="line"><span>  }</span></span>
<span class="line"><span> }</span></span></code></pre></div><p>The given fields are:</p><ul><li><code>uniformPath</code>(<code>String</code>): Represents the test name that will be shown in Teamscale</li><li><code>result</code>(<code>String</code>, default <code>PASSED</code>): The test execution result. Possible values for <code>result</code> include <code>PASSED</code>, <code>IGNORED</code>, <code>SKIPPED</code>, <code>FAILURE</code>, <code>ERROR</code>, and <code>INCONCLUSIVE</code>. See the <a href="./../../upload-formats-and-samples/testwise-coverage/#testinfo">Testwise Coverage specification</a> for details on the semantics of those values.</li><li><code>duration</code>(<code>double</code>, default <code>1</code>): Duration of the test execution interpreted as seconds For a full reference of supported fields see <a href="./../../upload-formats-and-samples/testwise-coverage/#testinfo">TestInfo</a>.</li></ul><p><code>teamscale-build</code> will look for test coverage to associate with the test next to the <code>metadata.json</code>. The coverage must be placed in directories named after the report formats (see <a href="#input-coverage-format">supported formats</a>) contained in them. If the folders contain multiple reports they will be merged.</p><p>An example directory schema be:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>root</span></span>
<span class="line"><span>  arbitarily/many/subfolders</span></span>
<span class="line"><span>    testcase-folder1</span></span>
<span class="line"><span>      metadata.json</span></span>
<span class="line"><span>      JACOCO</span></span>
<span class="line"><span>        report1.xml</span></span>
<span class="line"><span>        report2.xml</span></span>
<span class="line"><span>        ...</span></span>
<span class="line"><span>    testcase-folder2</span></span>
<span class="line"><span>      metadata.json</span></span>
<span class="line"><span>      SIMPLE</span></span>
<span class="line"><span>        simple-coverage.txt</span></span>
<span class="line"><span>    ...</span></span></code></pre></div><p>Where <code>root</code> is provided via the <code>-i</code> option. In this example, the coverage information from <code>report1.xml</code> and <code>report2.xml</code> would be mapped to the information provided in the <code>metadata.json</code> of <code>testcase-folder1</code> (JaCoCo coverage) and <code>simple-coverage.txt</code> will be linked to the <code>metadata.json</code> of <code>testcase-folder2</code> (SIMPLE coverage).</p><h3 id="command-specific-options-1" tabindex="-1">Command-specific options <a class="header-anchor" href="#command-specific-options-1" aria-label="Permalink to &quot;Command-specific options&quot;">​</a></h3><p>The following command-specific options are available:</p><ul><li><code>-c</code>/<code>--complete</code> (optional): By default, the generated Testwise Coverage report is flagged as &quot;partial&quot;, meaning Testwise Coverage in Teamscale for tests that are not included in this report is kept unchanged. If instead you’d like all tests that are not part of the generated report to be removed from Teamscale (e.g. because the tests were deleted meanwhile), you can mark the generated report as complete with this flag.</li><li><code>-u</code>/<code>--include-coverable-lines</code>: (optional): Determines whether coverable lines should be included in the output. This is only relevant information for languages with a pre-processor like C/C++/C#. Default is false. You will have to enable the feature toggle <code>-Dcom.teamscale.feature-toggle.use-coverable-lines-from-coverage-reports=true</code> on your Teamscale instance to let Teamscale make use of this data. By default, Teamscale will ignore that information and determine the coverable lines heuristically.</li></ul><h2 id="the-coverage-raw-testwise-command" tabindex="-1">The <code>coverage raw-testwise</code> command <a class="header-anchor" href="#the-coverage-raw-testwise-command" aria-label="Permalink to &quot;The \`coverage raw-testwise\` command&quot;">​</a></h2><p>The <code>coverage raw-testwise</code> command converts multiple Bullseye coverage reports to a single Raw Testwise Coverage report. The Raw Testwise Coverage report is very similar to the output of the <code>coverage testwise</code> command. Bullseye reports however cannot be converted via the <code>coverage testwise</code> command, since the original source code is needed for the conversion. Thus, this command packages the original reports into a single file that can be uploaded to Teamscale where the conversion happens. An example of the command would be:</p>`,15)),t(l,{sharedStateKey:"os"},{default:s(()=>[t(o,{label:"Linux"},{default:s(()=>[...a[24]||(a[24]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," raw-testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/project"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/raw-testwise-coverage.json")])])])],-1)])]),_:1}),t(o,{label:"Windows"},{default:s(()=>[...a[25]||(a[25]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-build.exe coverage raw-testwise -i C:\\project -o C:\\tmp\\raw-testwise-coverage.json")])])])],-1)])]),_:1}),t(o,{label:"macOS"},{default:s(()=>[...a[26]||(a[26]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-build"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," coverage"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," raw-testwise"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -i"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/project"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," -o"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," /tmp/raw-testwise-coverage.json")])])])],-1)])]),_:1})]),_:1}),a[35]||(a[35]=n('<p>For the upload you need to specify the <code>RAW_TESTWISE</code> format, which is available since Teamscale 9.2.</p><h3 id="input-path-structure-1" tabindex="-1">Input path structure <a class="header-anchor" href="#input-path-structure-1" aria-label="Permalink to &quot;Input path structure&quot;">​</a></h3><p>The input path and directory schema is the same as in the <code>testwise</code> command. The <code>raw-testwise</code> command supports any of <a href="./../../upload-formats-and-samples/#coverage">Teamscale&#39;s supported coverage formats</a>, but its main use-case remains the <code>BULLSEYE</code> format and the non-raw testwise command should be preferred if possible.</p><h3 id="command-specific-options-2" tabindex="-1">Command-specific options <a class="header-anchor" href="#command-specific-options-2" aria-label="Permalink to &quot;Command-specific options&quot;">​</a></h3><p>The following command-specific options are available:</p><ul><li><code>-c</code>/<code>--complete</code> (optional): By default, the generated Raw Testwise Coverage report is flagged as &quot;partial&quot;, meaning Testwise Coverage in Teamscale for tests that are not included in this report is kept unchanged. If instead you’d like all tests that are not part of the generated report to be removed from Teamscale (e.g. because the tests were deleted meanwhile), you can mark the generated report as complete with this flag.</li></ul><h1 id="common-options" tabindex="-1">Common Options <a class="header-anchor" href="#common-options" aria-label="Permalink to &quot;Common Options&quot;">​</a></h1><p>Many command-line options are common to all commands offered by <code>teamscale-build</code>. These are described in the following.</p><h2 id="input-path" tabindex="-1">Input path <a class="header-anchor" href="#input-path" aria-label="Permalink to &quot;Input path&quot;">​</a></h2><p>Option name: <code>-i</code> or <code>--input</code></p><p>Path of a report file or a directory containing report files that should be parsed. Can be used multiple times within the same command. All reports must have the same <a href="#input-coverage-format">coverage format</a>.</p><h2 id="input-coverage-format" tabindex="-1">Input coverage format <a class="header-anchor" href="#input-coverage-format" aria-label="Permalink to &quot;Input coverage format&quot;">​</a></h2><p>The report format of input coverage reports (case-insensitive). Can only be used once within the same command. Supported formats are</p><ul><li><code>CLOVER</code>: <a href="https://www.atlassian.com/software/clover" target="_blank" rel="noreferrer">Clover (Java/Groovy)</a></li><li><code>COBERTURA</code>: <a href="https://cobertura.github.io/cobertura/" target="_blank" rel="noreferrer">Cobertura (Java)</a></li><li><code>CTC</code>: <a href="http://www.testwell.fi/ctcdesc.html" target="_blank" rel="noreferrer">Testwell CTC++ (C/C++)</a></li><li><code>DOT_COVER</code>: <a href="https://www.jetbrains.com/dotcover/" target="_blank" rel="noreferrer">dotCover (C#)</a></li><li><code>GCOV</code>: <a href="https://gcc.gnu.org/onlinedocs/gcc/Gcov.html" target="_blank" rel="noreferrer">gcov (C/C++)</a></li><li><code>GOLANG_COVERAGE</code>: <a href="https://pkg.go.dev/cmd/go#hdr-Testing_flags" target="_blank" rel="noreferrer">Go Coverage (Go)</a></li><li><code>IEC_COVERAGE</code>: Default Coverage Format For Structured Text/IEC 61131-3 (ST)</li><li><code>JACOCO</code>: <a href="https://www.jacoco.org/" target="_blank" rel="noreferrer">JaCoCo (Java)</a></li><li><code>JLINK_CSV</code>: <a href="https://www.segger.com/products/development-tools/ozone-j-link-debugger/technology/trace-reports/" target="_blank" rel="noreferrer">J-Link/Ozone coverage (C/C++)</a></li><li><code>LCOV</code>: <a href="https://github.com/linux-test-project/lcov" target="_blank" rel="noreferrer">lcov (JavaScript, C/C++)</a></li><li><code>LLVM</code>: <a href="https://llvm.org" target="_blank" rel="noreferrer">LLVM coverage (Ada, C/C++, Delphi, Fortran, Kotlin, Objective-C, Swift)</a></li><li><code>SIMPLE</code>: <a href="./../../upload-formats-and-samples/#example-file-for-teamscale-simple-coverage">Teamscale Simple Coverage (any)</a></li><li><code>TEAMSCALE_COMPACT_COVERAGE</code>: <a href="./../../upload-formats-and-samples/teamscale-compact-coverage/">Teamscale Compact Coverage (any)</a></li><li><code>VS_COVERAGE</code>: <a href="https://learn.microsoft.com/en-gb/visualstudio/test/using-code-coverage-to-determine-how-much-code-is-being-tested" target="_blank" rel="noreferrer">Visual Studio Test Coverage (C/C++, C#)</a></li><li><code>XCODE</code>: XCode/xccov Coverage (Swift)</li></ul><div class="tip custom-block"><p class="custom-block-title">Teamscale-supported formats</p><p>The supported formats are a subset of all <a href="./../../supported-technologies/test-coverage/">Teamscale-supported formats</a>.</p></div><h2 id="output-path" tabindex="-1">Output path <a class="header-anchor" href="#output-path" aria-label="Permalink to &quot;Output path&quot;">​</a></h2><p>Option name: <code>-o</code> or <code>--output</code></p><p>Path of the to be generated coverage report output file. In case a file exists at this path, the file will not be overwritten, but instead, the command fails.</p><h2 id="logging" tabindex="-1">Logging <a class="header-anchor" href="#logging" aria-label="Permalink to &quot;Logging&quot;">​</a></h2><p>Option name: <code>--stacktrace</code></p><p>In case any problems arise, or you need to report an issue to our <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support</a>, you can log trace information by using the <code>--stacktrace</code> option.</p>',21))])}const w=c(m,[["render",u]]);export{y as __pageData,w as default};
