import{_ as t,c as o,ak as r,o as s}from"./chunks/framework.AfHpRKMk.js";const n="/assets/github-issue-server-url-selection-dropdown-menu.CEf6rb5Z.png",a="/assets/jira-issue-update-configuration-menu.Dolyc0he.png",g=JSON.parse('{"title":"Repository Connector Options","description":"","frontmatter":{"title":"Repository Connector Options"},"headers":[],"relativePath":"reference/connector-options/index.md","filePath":"reference/connector-options/index.md"}'),i={name:"reference/connector-options/index.md"};function d(c,e,l,h,p,u){return s(),o("div",null,[...e[0]||(e[0]=[r(`<h1 id="repository-connector-options-reference-svn-git-azure-devops-etc" tabindex="-1">Repository Connector Options Reference (SVN, Git, Azure DevOps, etc.) <a class="header-anchor" href="#repository-connector-options-reference-svn-git-azure-devops-etc" aria-label="Permalink to &quot;Repository Connector Options Reference (SVN, Git, Azure DevOps, etc.)&quot;">​</a></h1><p>To create a project, Teamscale needs to be connected to your version control system. To this end, it offers several different repository connectors. We describe the options for each repository connector.</p><nav class="table-of-contents"><ul><li><a href="#shared-connector-options">Shared Connector Options</a><ul><li><a href="#common-and-git-specific-connector-options">Common and Git-specific Connector Options</a></li><li><a href="#team-foundation-server-tfs-specific-connector-options">Team Foundation Server (TFS)-specific Connector Options</a></li><li><a href="#subversion-svn-specific-connector-options">Subversion (SVN)-specific Connector Options</a></li><li><a href="#file-system-specific-connector-options">File System-specific Connector Options</a></li><li><a href="#vote-supporting-connector-options">Vote-Supporting Connector Options</a></li></ul></li><li><a href="#bitbucket-data-center">Bitbucket Data Center</a><ul><li><a href="#bitbucket-data-center-options">Bitbucket Data Center Options</a></li></ul></li><li><a href="#gerrit">Gerrit</a><ul><li><a href="#gerrit-connector-options">Gerrit Connector Options</a></li></ul></li><li><a href="#github">GitHub</a><ul><li><a href="#github-options">GitHub Options</a></li></ul></li><li><a href="#gitlab">GitLab</a><ul><li><a href="#gitlab-options">GitLab Options</a></li></ul></li><li><a href="#subversion-svn-branch-analysis">Subversion (SVN) Branch Analysis</a></li><li><a href="#subversion-authentication-problems">Subversion Authentication Problems</a></li><li><a href="#azure-devops-team-foundation-version-control-credentials-formerly-called-team-foundation-server-tfs">Azure DevOps Team Foundation Version Control Credentials (formerly called Team Foundation Server (TFS))</a></li><li><a href="#artifactory-connector-options">Artifactory Connector Options</a><ul><li><a href="#artifactory-connector-options-1">Artifactory Connector Options</a></li></ul></li><li><a href="#s3-connector">S3 Connector</a><ul><li><a href="#s3-connector-account-credentials">S3 Connector Account Credentials</a></li><li><a href="#s3-connector-options">S3 Connector Options</a></li></ul></li><li><a href="#issue-tracker-connector-options">Issue Tracker Connector Options</a><ul><li><a href="#options-for-all-issue-tracker-connectors">Options for all Issue Tracker Connectors</a></li></ul></li><li><a href="#jira-server-issue-update-option-details">Jira Server Issue Update Option Details</a></li><li><a href="#requirements-management-tool-connector-options">Requirements Management Tool Connector Options</a><ul><li><a href="#options-for-all-requirements-management-tool-connectors">Options for all Requirements Management Tool Connectors</a></li><li><a href="#jira-specific-requirements-management-tool-connector-options">Jira-specific Requirements Management Tool Connector Options</a></li><li><a href="#polarion-specific-requirements-management-tool-connector-options">Polarion-specific Requirements Management Tool Connector Options</a></li><li><a href="#rtc-jazz-specific-requirements-management-tool-connector-options">RTC/Jazz-specific Requirements Management Tool Connector Options</a></li><li><a href="#azure-devops-specific-requirements-management-tool-connector-options">Azure-Devops-specific Requirements Management Tool Connector Options</a></li><li><a href="#codebeamer-specific-requirements-management-tool-connector-options">Codebeamer-specific Requirements Management Tool Connector Options</a></li></ul></li></ul></nav><h2 id="shared-connector-options" tabindex="-1">Shared Connector Options <a class="header-anchor" href="#shared-connector-options" aria-label="Permalink to &quot;Shared Connector Options&quot;">​</a></h2><p>Setting up the other connectors to source code repositories and issue trackers is very similar to the Git connector setup. Many connectors share general options such as a <strong>polling interval</strong> and therefore, we only describe the options (if there are any) for first connector that uses it. If there are no additional options in a connector, we don&#39;t document the connector separately.</p><h3 id="common-and-git-specific-connector-options" tabindex="-1">Common and Git-specific Connector Options <a class="header-anchor" href="#common-and-git-specific-connector-options" aria-label="Permalink to &quot;Common and Git-specific Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Default branch name</strong></td><td>The name of the branch to import.</td></tr><tr><td><strong>Account</strong></td><td>Account credentials that Teamscale will use to access the repository. Clicking on the <i class="plus circle icon"></i> button opens a credentials creation dialog. <br><ul><li><small>The Account Name setting in the dialog is Teamscale-internal (does not need to match anything in git). </small></li><li><small>When using a <strong>file URL</strong> (<code>file:///</code>) in the account, make sure that the corresponding repository is <code>bare</code>, i.e. has been cloned with the <code>--bare</code> option. </small></li></ul></td></tr><tr><td><strong>Path suffix</strong></td><td>Should Teamscale only analyze a subdirectory of the repository?</td></tr><tr><td><strong>Repository identifier</strong></td><td>Teamscale will use this identifier to distinguish different repositories in the same project. (Teamscale-internal only)</td></tr><tr><td><strong>Included file names</strong></td><td>One or more <a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> separated by comma or newline to restrict the analysis on a subset of files. A file is included in the analysis if any of the supplied patterns match. Typical examples: <ul><li>include all Java and JS files: <code>**.java, **.js</code></li><li>include all Java and JS files in a specific folder: <code>*/folder/*.java, */folder/*.js</code></li></ul></td></tr><tr><td><strong>Excluded file names</strong></td><td>One or more <a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> separated by comma or newline to exclude from the analysis. A file will be excluded if any of the exclude patterns match. Typical examples: <ul><li>exclude a certain folder: <code>*/folder/*</code></li><li>exclude files that end with Test or test: <code>*/[Tt]est.cs</code></li><li>exclude a top-level folder: <code>folder/**</code></li></ul></td></tr><tr><td><strong>Important Branches</strong></td><td>Important branches are preferred in addition to the default branch when assigning commits to branches. List of regular expressions with decreasing priority. <br> Examples: <code>develop</code>, <code>release/</code></td></tr><tr><td><strong>Include submodules</strong></td><td>Whether to also analyze code in submodules. </td></tr><tr><td><strong>Submodule recursion depth</strong></td><td>The maximum depths of nested submodules that will be analyzed. (Has no effect if <strong>Include submodules</strong> is not selected.) </td></tr><tr><td><strong>SSH Private Key ID</strong></td><td>The ID of an SSH private key stored in Teamscale which will be used when <a href="../../howto/connecting-version-control-system/git-with-ssh/">connecting to a Git Account over SSH</a>. <br><small>You can manage all your Git private keys on the Settings page of the Admin perspective, in the Git section. When using a Git private key, the Account used by the connector has to be configured as follows: The URL has to contain the user name (e.g., <code>ssh://username@gitserver/path/to/repo.git</code>), the password and the username may be left empty.</small></td></tr><tr><td><strong>Enable branch analysis</strong></td><td>This checkbox activates our branch support feature. If you select it, Teamscale will analyze all branches of the repository. If branch analysis is enabled, the <strong>Default branch name</strong> option specifies the main branch (usually <code>main</code> or <code>master</code>)</td></tr><tr><td><strong>Included branches</strong></td><td>Explicitly control which branches will be analyzed. (hidden if <strong>Enable branch analysis</strong> is not selected.)</td></tr><tr><td><strong>Excluded branches</strong></td><td>Explicitly state which branches to exclude. Note that Teamscale will create so called <strong>anonymous branches</strong> for all historic branches whose name could not be reconstructed. By default these are filtered using the exclude pattern <code>_anon.*</code></td></tr><tr><td><strong>Start revision</strong></td><td>The first revision that will be analyzed. You can enter a date (which selects the first revision after the date) or a revision hash.</td></tr><tr><td><strong>End revision (expert option)</strong></td><td>The last revision that will be analyzed. If the default value is selected, the history up to the latest revision is read.</td></tr><tr><td><strong>Content exclude</strong></td><td>A comma-separated list of regular expressions. Teamscale will exclude all files that match one of these filters.</td></tr><tr><td><strong>Polling interval</strong></td><td>How often should we query the repository and update our findings? (Unit is seconds)</td></tr><tr><td><strong>Include files stored via Git LFS</strong></td><td>Teamscale can be configured to manage files stored via <a href="https://git-lfs.com/">Git Large File Storage (LFS)</a>.<small><ul><li><strong>Enabled:</strong> Teamscale automatically resolves and downloads files stored via Git LFS, including them in its analysis.</li><li><strong>Disabled:</strong> Teamscale does not resolve Git LFS files, which may result in unresolved files appearing as <a href="https://github.com/git-lfs/git-lfs/blob/main/docs/spec.md">Git LFS pointer files</a>.</li></ul><strong>Note:</strong> Teamscale currently only supports fetching Git LFS files via HTTP/HTTPS.</small></td></tr><tr><td><strong>Test-code path pattern (expert option)</strong></td><td><a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> describing the file paths to be considered test code. Files that match one of the given patterns are considered to be test code unless also matched by a pattern in <code>Test-code path exclude pattern</code>. Patterns can be separated by comma or newline. Files matched as test code will be excluded from test gap treemaps, will not have a line coverage metric calculated and are not considered for the &quot;Test Coverage&quot; feature in the Merge Request details view.</td></tr><tr><td><strong>Test-code path exclude pattern (expert option)</strong></td><td><a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> describing the file paths that should be excluded from the test-code files matched by option <code>Test-code path pattern</code>. Files that match one of the given patterns will not be considered test code. Patterns can be separated by comma or newline.</td></tr><tr><td><strong>Branch transformation (expert option)</strong></td><td>Regex transformations that are applied to the branch names of the repository. The mapping should be one-to-one. This can be used to unify branch names (e.g. master vs. main) within a Teamscale project using multiple repository connectors. <br> Example: <code>&#39;^master$ -&gt; main&#39;</code><br>Please note that the transformation is applied on any substring matching the pattern, i.e. when only matching the full name is intended, wrapping the left hand side in ^ and $ is required, as shown in the example.</td></tr><tr><td><strong>Prepend repository identifier (expert option)</strong></td><td>Whether to include the repository identifier as a prefix for the created file paths.</td></tr><tr><td><strong>Text filter (expert option)</strong></td><td> One or more regular expressions separated by comma describing what parts of a file should be excluded from analysis (e.g. generated code).</td></tr><tr><td><strong>Language mapping (expert option)</strong></td><td>Mapping from <a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> to language used to override default language mapping. Typical examples: <ul><li><code>**.jav -&gt; JAVA</code></li><li><code>**/code/*.sql -&gt; PLSQL</code></li></ul></td></tr><tr><td><strong>Analysis report mapping (expert option)</strong></td><td>Mapping from <a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> to report format to be imported. Typical examples: <ul><li><code>**/junit.xml -&gt; JUNIT</code></li><li><code>**/jacoco.xml -&gt; JACOCO</code></li></ul></td></tr><tr><td><strong>Partition Pattern (expert option)</strong></td><td>A regular expression to extract the partition from the path of the artifacts. The first non-null group is used as partition. <br>Example: <code>coverage/([^/]+)/</code> to use sub-folders of coverage as partition </td></tr><tr><td><strong>File-size exclude (expert option)</strong></td><td>A file size limit (i.e., contents of larger files are shown in grey and not analyzed) given in bytes with units (e.g. <code>B</code>, <code>KB</code>, <code>KiB</code>). Defaults to <code>1MB</code> which corresponds to about <code>20-30 kLOC</code>.</td></tr><tr><td><strong>Source library connector (expert option)</strong></td><td>Determines if the contained files should only be used for source library lookup, but not for analysis. For example, this can be used for third-party C/C++ header files that are required for compilation.</td></tr><tr><td><strong>Run to exhaustion (expert option)</strong></td><td>Determines if the repository should not be polled after the current head is reached.</td></tr><tr><td><strong>Preserve empty commits (expert option)</strong></td><td>Determines if Teamscale should also read and process commits without relevant changes. This can be useful for showing these in the activity stream as well or for post-processing empty commits (e.g. for Gerrit voting). Disabling this can improve performance. Please note that all fork commits will be preserved in any case, even if they are empty and this option is not set. </td></tr><tr><td><strong>Delta size (expert option)</strong></td><td>Adjusts the size of deltas produced by this connector.</td></tr><tr><td><strong>Path prefix transformation (expert option)</strong></td><td> Prefix transformations that are applied to the paths from the repository. Examples: <ul><li><code>some_project/trunk -&gt; some_project</code></li><li><code>other_project/trunk -&gt; the_project</code></li></ul></td></tr><tr><td><strong>Path transformation (expert option)</strong></td><td>Regex transformations that are applied to the paths from the repository. <br> Example: <code>/trunk/ -&gt; /</code></td></tr><tr><td><strong>Encoding (expert option)</strong></td><td>Sets the encoding to be used when reading files (e.g. <code>UTF-8</code>, <code>latin1</code>).</td></tr><tr><td><strong>Author transformation (expert option)</strong></td><td>Regex transformations that are applied to the authors of the repository. <br> Example: <code>Bob -&gt; Robert</code></td></tr><tr><td><strong>Fetch additional ref specs (expert option)</strong></td><td>Option for fetching additional <a href="https://git-scm.com/book/en/v2/Git-Internals-The-Refspec">ref specs</a>. Allows users to specify additional ref specs to fetch, as well as an extraction pattern to display them in the UI. The additional refs can be picked as git tags in the time picker UI. <br> Example: <code>refs/builds/tags/*:refs/remotes/origin/builds/tags/* -&gt; refs/remotes/origin/builds/tags/./.\\.(.*)</code></td></tr><tr><td><strong>Skip Voting on merge requests without relevant changes (expert option)</strong></td><td>Whether Teamscale should vote on merge requests that do not contain any relevant changes. If set, also results in Teamscale not producing any findings badge in the merge request.</td></tr></tbody></table><h3 id="team-foundation-server-tfs-specific-connector-options" tabindex="-1">Team Foundation Server (TFS)-specific Connector Options <a class="header-anchor" href="#team-foundation-server-tfs-specific-connector-options" aria-label="Permalink to &quot;Team Foundation Server (TFS)-specific Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Path suffix</strong></td><td>A common subdirectory on the Azure DevOps Server appended to the account URI. Leave empty if the whole directory structure is relevant. This is the root directory when looking for branches if branching is enabled.</td></tr><tr><td><strong>Branch path suffix</strong></td><td>The sub path (relative to the branches) that should be analyzed. Leave empty to analyze all code within each branch.</td></tr><tr><td><strong>Branch lookup paths</strong></td><td>The paths in the repository separated by commas where Teamscale will search for branches within the root directory defined by the Path suffix and account URI. If set, Teamscale only looks for branches on the top level of each branch lookup path. If empty only the root directory is searched for branches on the top level.</td></tr><tr><td><strong>Included/Excluded branches</strong></td><td>Included and excluded branches must contain the full path to the branch relative to the root directory. This means the Branch lookup paths appended with the contained branch</td></tr><tr><td><strong>Non-branched mode</strong></td><td>Activates the non-branched mode for TFS. If it is enabled, Teamscale ignores the default branch and treats everything found in the root directory of the repository as content to analyse. If the option is disabled, Teamscale interprets the directories found at the <strong>Branch lookup paths</strong> as branches. It is not possible to enable both the branch analysis and the non-branched mode.</td></tr></tbody></table><h3 id="subversion-svn-specific-connector-options" tabindex="-1">Subversion (SVN)-specific Connector Options <a class="header-anchor" href="#subversion-svn-specific-connector-options" aria-label="Permalink to &quot;Subversion (SVN)-specific Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Enable Externals</strong></td><td>Whether to also parse and interpret svn:externals properties.</td></tr><tr><td><strong>Externals Includes/Excludes (expert option)</strong></td><td>Comma separated list of <a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> describing the directories that are (not) checked for <code>svn:externals</code>. Use <code>.</code> to denote the top-level directory.</td></tr><tr><td><strong>Branches directory</strong></td><td>A path in which to look for branches. Defaults to <code>branches</code>.</td></tr><tr><td><strong>Ignored Revisions (expert option)</strong></td><td>List of revisions to be ignored when crawling the SVN repository. This can be used to exclude revisions that describe erroneous SVN operations, such as invalid branch creations, that later have been corrected. Note that misuse of this option can lead to unexpected analysis behavior.</td></tr></tbody></table><h3 id="file-system-specific-connector-options" tabindex="-1">File System-specific Connector Options <a class="header-anchor" href="#file-system-specific-connector-options" aria-label="Permalink to &quot;File System-specific Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Input directory</strong></td><td>The path of the source-code directory</td></tr></tbody></table><h3 id="vote-supporting-connector-options" tabindex="-1">Vote-Supporting Connector Options <a class="header-anchor" href="#vote-supporting-connector-options" aria-label="Permalink to &quot;Vote-Supporting Connector Options&quot;">​</a></h3><p>Teamscale can cast merge request <a href="./../../glossary/#voting">votes</a> on platforms that support it. The connectors that implement this behavior are:</p><ul><li>Azure DevOps Git</li><li>Bitbucket Cloud</li><li>Bitbucket Data Center</li><li>Gerrit</li><li>Gitea</li><li>GitHub</li><li>GitLab</li><li>SCM-Manager</li></ul><p>The common options for these connectors are:</p><table><tbody><tr><td><strong>Enable Findings Integration</strong></td><td>Prerequisite for all findings related merge request actions. Opens up options like Findings badges. This option does nothing on its own.</td></tr><tr><td><strong>Enable Findings Badge</strong></td><td>Includes Teamscale <a href="../../glossary/#findings-badge">findings badge</a> in voting. This badge is usually added to the merge request&#39;s description and shows the findings churn of the merge request, i.e. findings that were added, removed or are in changed code of this merge request.</td></tr><tr><td><strong>Enable Voting for Findings</strong></td><td>Whether Teamscale should vote on merge requests. The vote reflects whether new findings are introduced in the merge request. Depending on the platform and more specifically the repositories&#39; configuration, this can block the merging of a merge request.</td></tr><tr><td><strong>Enable Detailed Line Comments For Findings</strong></td><td>When enabled, a Teamscale vote will carry a detailed comment for each generated finding that is annotated to the relevant line in the reviewed file.</td></tr><tr><td><strong>Enable Testing Integration for Merge Requests</strong></td><td>Prerequisite for all test related merge request actions. Opens up options like Test Gap integration or voting for Test Coverage. This option does nothing on its own.</td></tr><tr><td><strong>Enable Test Gap Integration for Merge Requests</strong></td><td>Prerequisite for all test gap related merge request actions. Opens up options like Test Gap badges and Test Gap line comments. This option does nothing on its own.</td></tr><tr><td><strong>Enable Test Gap Badges</strong></td><td>Includes Teamscale <a href="../../glossary/#test-gap-badge">test gap badge</a> in voting. This badge is usually added to the merge requests description.</td></tr><tr><td><strong>Add Detailed Line Comments for Test Gaps</strong></td><td> When enabled, a Teamscale vote will add a detailed comment for each untested method or function. Comments are annotated to the relevant methods or functions in the reviewed files in the merge request diff view. Test Gap comments will be added, provided that the following conditions are fulfilled: <ul><li>All partitions listed in the <em>&quot;Partitions required for Voting&quot;</em> option, if any, have received external uploads after the latest code commit.</li><li>Teamscale is not waiting for any more test data to be uploaded (i.e. the <a href="../../howto/configuring-build-completeness-check/">build completeness check</a> succeeds).</li><li>The Teamscale project has at least one partition with test coverage data.</li><li>At least one test coverage partition has been updated after the merge request&#39;s head commit.</li></ul></td></tr><tr><td><strong>Add Test Gaps Summary in a Single Comment</strong></td><td> When enabled, a Teamscale vote will add a single merge request comment with a summary of all the untested methods or functions in the merge request. The Test Gap summary comment will be added, provided that the following conditions are fulfilled: <ul><li>All partitions listed in the <em>&quot;Partitions required for Voting&quot;</em> option, if any, have received external uploads after the latest code commit.</li><li>Teamscale is not waiting for any more test data to be uploaded (i.e. the <a href="../../howto/configuring-build-completeness-check/">build completeness check</a> succeeds).</li><li>The Teamscale project has at least one partition with test coverage data.</li><li>At least one test coverage partition has been updated after the merge request&#39;s head commit.</li></ul></td></tr><tr><td><strong>Limit for Test Gap Comments</strong></td><td> Maximum allowed number of test gap comments when annotating merge requests, in case the &quot;Add Detailed Line Comments for Test Gaps&quot; option or the &quot;Add Test Gaps Summary in a Single Comment&quot; option is enabled. <ul><li>For the &quot;Add Detailed Line Comments for Test Gaps&quot; option, if the number of test gaps exceeds the limit, no line comments will be added to the merge request and a warning message is displayed.</li><li>For the &quot;Add Test Gaps Summary in a Single Comment&quot; option, the maximum number of test gaps listed in the comment will not exceed the set limit. Any test gaps beyond the limit will not be displayed.</li></ul></td></tr><tr><td><strong>Enable Commit Alerts for Merge Requests</strong></td><td>When enabled, a Teamscale vote will carry a detailed comment for each commit alert that is annotated to the relevant file.</td></tr><tr><td><strong>Aggregate Findings in Single Comment</strong></td><td>When enabled, Teamscale will aggregate all related findings in a commit into a single comment before annotating it to the reviewed file. The aggregated findings could be multiple identical findings or different findings sharing the same type (e.g. structure findings). This aims to reduce redundancy and not to overcrowd the merge request with repetitive comments. Example: if a commit introduced 20 &quot;Interface comment missing&quot; findings, instead of adding 20 individual comments to the merge request, Teamscale will only add a single comment &quot;This file contains 20 instances of: Interface comment missing&quot;. </td></tr><tr><td><strong>Ignore Yellow Findings For Votes (expert option)</strong></td><td>When enabled, only red findings will cause Teamscale to cast a negative vote on merge requests. Note that this option has a different behavior for the <a href="#gerrit-connector-options">Gerrit connector</a>.</td></tr><tr><td><strong>Ignore Yellow Findings For Comments (expert option)</strong></td><td>When enabled, Teamscale will only add comments for red findings to the merge request.</td></tr><tr><td><strong>Partitions required for Voting (expert option)</strong></td><td>Comma separated list of external upload partitions that are expected to be present after a code commit to actually vote. This is used to prevent voting too early when further external uploads (e.g., test coverage reports) are expected.</td></tr><tr><td><strong>Detailed Line Comments Limit</strong></td><td>Maximum allowed number of detailed line comments when annotating merge requests, in case the &quot;Enable Detailed Line Comments For Findings&quot; option is enabled. If the number of added findings exceeds the limit, no line comments will be added to the merge request and a warning message is displayed. Please note that some platforms enforce limits in their API.</td></tr><tr><td><strong>Vote Include/Exclude Patterns (expert option)</strong></td><td>The include/exclude-filename patterns filter findings from both the findings badge (if the badge is enabled) and the inline comments (if they are enabled). Teamscale will still add a findings badge, even if none of the changed files of a merge request match the filter.</td></tr><tr><td><strong>Line coverage threshold</strong></td><td>The required line coverage for added and changed lines (in percent, 0-100). Merge requests with a lower changed line coverage will receive a negative vote.</td></tr><tr><td><strong>Badges for Critical Changes (expert option)</strong></td><td> Badges added to merge requests indicating that modifications in predefined critical code areas occurred. Detailed instructions on configuring the critical change badges can be found <a href="../../howto/tracking-critical-changes-in-merge-requests">here</a>. </td></tr></tbody></table><h2 id="bitbucket-data-center" tabindex="-1">Bitbucket Data Center <a class="header-anchor" href="#bitbucket-data-center" aria-label="Permalink to &quot;Bitbucket Data Center&quot;">​</a></h2><p>The Bitbucket Data Center connector can access Git repositories of Bitbucket Data Center instances and can additionally vote on pull requests.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>For a visualization of how Teamscale votes in Bitbucket Data Center, see our <a href="./../../howto/connecting-version-control-system/bitbucket/">how-to guide</a>.</p></div><h3 id="bitbucket-data-center-options" tabindex="-1">Bitbucket Data Center Options <a class="header-anchor" href="#bitbucket-data-center-options" aria-label="Permalink to &quot;Bitbucket Data Center Options&quot;">​</a></h3><table><tbody><tr><td><strong>Enable Voting for Findings</strong></td><td>Whether Teamscale should vote on pull requests based on the presence of new findings. The vote is added as a <strong>build status</strong> and can potentially block the merging of pull requests, depending on the repository&#39;s configuration.</td></tr><tr><td><strong>Enable Voting for Test Gaps</strong></td><td>Whether Teamscale should vote on pull requests based on the presence of test gaps. The vote is added as a <strong>build status</strong> and can potentially block the merging of pull requests, depending on the repository&#39;s configuration.</td></tr><tr><td><strong>Ignore yellow Test Gaps for voting</strong></td><td>When enabled, test gaps in changed methods (&quot;yellow&quot; test gaps) are ignored when voting based on the presence of test gaps.</td></tr><tr><td><strong>Enable Voting for Test Coverage</strong></td><td>Whether Teamscale should vote on pull requests based on the test coverage percentage. The vote considers the coverage threshold specified by the option &quot;Line coverage threshold&quot; and whether it was reached or not. The vote is added as a <strong>check</strong> and can potentially block the merging of pull requests, depending on the repository&#39;s configuration.</td></tr><tr><td><strong>Included build jobs</strong></td><td>Regular expressions describing the merge request build jobs to wait for before voting with test data. Build jobs will be matched case-sensitively.</td></tr><tr><td><strong>Excluded build jobs</strong></td><td>Regular expressions describing the merge request build jobs to be excluded and not considered when voting with test gap data. Build jobs will be matched case-sensitively.</td></tr><tr><td><strong>Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments</strong></td><td>When enabled, Teamscale will add inline comments for findings and test gaps as actual comments on the pull request.</td></tr><tr><td><strong>Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report</strong></td><td>When enabled, Teamscale will use the Bitbucket Code Insights reports to add comments for findings and test gaps.</td></tr><tr><td><strong>Build polling interval</strong></td><td>Delay used for polling the merge requests&#39; build jobs in seconds.</td></tr><tr><td><strong>Enable pull request review (expert option)</strong></td><td>Votes by submitting a pull request review in addition to the build status. Combines the results of all enabled votes (Findings, Test Gaps, Test Coverage).</td></tr><tr><td><strong>Add badges in a pull request comment (expert option)</strong></td><td>When enabled, Teamscale will add all enabled badges (e.g. Findings Badge, Test Gap Badge, etc.) in a pull request comment, instead of adding the badges in the pull request description.</td></tr><tr><td><strong>Badges for Metrics (expert option)</strong></td><td>Metrics which should be tracked in merge requests via badges.</td></tr><tr><td><strong>Badges for Metric Groups (expert option)</strong></td><td>Metrics which should be included in summary badges for metric groups. These badges show the aggregated results of all the selected metrics in a group, e.g. the number of improved or deteriorated metrics in this group.</td></tr></tbody></table><h2 id="gerrit" tabindex="-1">Gerrit <a class="header-anchor" href="#gerrit" aria-label="Permalink to &quot;Gerrit&quot;">​</a></h2><p>The Gerrit connector can access Gerrit-managed Git repositories, and can additionally vote on changes.</p><h3 id="gerrit-connector-options" tabindex="-1">Gerrit Connector Options <a class="header-anchor" href="#gerrit-connector-options" aria-label="Permalink to &quot;Gerrit Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Project Name</strong></td><td>The name of the Gerrit project to connect with.</td></tr><tr><td><strong>Ignore Yellow Findings For Votes (expert option)</strong></td><td>When this option is enabled, the voting will be performed according to the following rules: <ul><li>Vote +1 <i>only</i> if there are no findings.</li><li>Vote 0 if there are <i>only yellow </i>findings.</li><li>Vote -1 if there are <i>any red </i>findings.</li></ul></td></tr><tr><td><strong>Read Timeout (expert option)</strong></td><td>The timeout (in seconds) used for reading data from Gerrit.</td></tr><tr><td><strong>Authentication Mode (expert option)</strong></td><td>The mode to use for authentication. Choose basic fallback mode if regular basic mode does not work. Possible authentication modes: <ul><li><code>NONE</code> No authentication</li><li><code>BASIC</code> Basic Authentication.</li><li><code>BEARER</code> Bearer/Token Authentication.</li><li><code>DIGEST</code> Digest Authentication.</li><li><code>BASIC_NTLM</code> Tries first basic authentication and if it fails NTLM.</li><li><code>JWT</code>: JWT Token Authentication.</li></ul></td></tr><tr><td><strong>Review Label (expert option)</strong></td><td>The review label used to upload feedback to Gerrit. Defaults to <code>Code-Review</code></td></tr><tr><td><strong>Minimum Change Creation Date (expert option)</strong></td><td>If this is set, the first analysis run will only consider open changes created after the given date. Changes that have been closed before the time of the first analysis run will be discarded completely.</td></tr><tr><td><strong>Fetch Merged Changes (expert option)</strong></td><td>If this is set, merged changes are also fetched.</td></tr></tbody></table><h2 id="github" tabindex="-1">GitHub <a class="header-anchor" href="#github" aria-label="Permalink to &quot;GitHub&quot;">​</a></h2><p>The GitHub connector can access Git repositories of GitHub instances and can additionally vote on pull requests.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>For a visualization of how Teamscale votes in GitHub, see our <a href="./../../howto/connecting-version-control-system/github/">how-to guide</a>.</p></div><h3 id="github-options" tabindex="-1">GitHub Options <a class="header-anchor" href="#github-options" aria-label="Permalink to &quot;GitHub Options&quot;">​</a></h3><table><tbody><tr><td><strong>Enable Voting for Test Gaps</strong></td><td>Whether Teamscale should vote on pull requests based on the presence of test gaps. The vote is added as a <strong>check</strong> and can potentially block the merging of pull requests, depending on the repository&#39;s configuration.</td></tr><tr><td><strong>Ignore yellow Test Gaps for voting</strong></td><td>When enabled, test gaps in changed methods (&quot;yellow&quot; test gaps) are ignored when voting based on the presence of test gaps.</td></tr><tr><td><strong>Enable Voting for Test Coverage</strong></td><td>Whether Teamscale should vote on pull requests based on the test coverage percentage. The vote considers the coverage threshold specified by the option &quot;Line coverage threshold&quot; and whether it was reached or not. The vote is added as a <strong>check</strong> and can potentially block the merging of pull requests, depending on the repository&#39;s configuration.</td></tr><tr><td><strong>Included build jobs</strong></td><td>Regular expressions describing the merge request build jobs to wait for before voting with test gap data. Build jobs will be matched case-sensitively.</td></tr><tr><td><strong>Excluded build jobs</strong></td><td>Regular expressions describing the merge request build jobs to be excluded and not considered when voting with test data. Build jobs will be matched case-sensitively.</td></tr><tr><td><strong>Build polling interval</strong></td><td>Delay used for polling the merge requests&#39; build jobs in seconds.</td></tr><tr><td><strong>GitHub Server URL</strong></td><td>The URL the GitHub instance is reachable at.</td></tr><tr><td><strong>Context identifier (expert option)</strong></td><td>The context identifier used for uploading the status to GitHub. Defaults to <code>teamscale</code>, but can be changed if multiple projects should vote for the same GitHub repository.</td></tr><tr><td><strong>Disable automatic webhook creation (expert option)</strong></td><td>If this is set to true, Teamscale will not create the required webhooks. Instead, you are responsible to set up webhooks according to the documentation to allow proper voting.</td></tr><tr><td><strong>Ignore webhooks from configured user (expert option)</strong></td><td>If this is set to true, Teamscale will ignore any webhooks triggered by the user configured in this connector, in order to avoid useless round-trips to the server. For production setups, this should be enabled and used with a dedicated build user.</td></tr><tr><td><strong>Findings badge position (expert option)</strong></td><td>The position of where to display the findings badge in the pull request.</td></tr><tr><td><strong>Badges for Metrics (expert option)</strong></td><td>Metrics which should be tracked in merge requests via badges.</td></tr><tr><td><strong>Badges for Metric Groups (expert option)</strong></td><td>Metrics which should be included in summary badges for metric groups. These badges show the aggregated results of all the selected metrics in a group, e.g. the number of improved or deteriorated metrics in this group.</td></tr></tbody></table><h2 id="gitlab" tabindex="-1">GitLab <a class="header-anchor" href="#gitlab" aria-label="Permalink to &quot;GitLab&quot;">​</a></h2><p>The GitLab connector can access Git repositories of GitLab instances and can additionally annotate merge requests.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>For a visualization of how Teamscale votes in GitLab, see our <a href="./../../howto/connecting-version-control-system/gitlab/">how-to guide</a>.</p></div><h3 id="gitlab-options" tabindex="-1">GitLab Options <a class="header-anchor" href="#gitlab-options" aria-label="Permalink to &quot;GitLab Options&quot;">​</a></h3><table><tbody><tr><td><strong>Included build jobs</strong></td><td>Regular expressions describing the merge request build jobs to wait for before voting with test gap data. Build jobs will be matched case-sensitively.</td></tr><tr><td><strong>Excluded build jobs</strong></td><td>Regular expressions describing the merge request build jobs to be excluded and not considered when voting with test gap data. Build jobs will be matched case-sensitively.</td></tr><tr><td><strong>Build polling interval</strong></td><td>Delay used for polling the merge requests&#39; build jobs in seconds.</td></tr></tbody></table><h2 id="subversion-svn-branch-analysis" tabindex="-1">Subversion (SVN) Branch Analysis <a class="header-anchor" href="#subversion-svn-branch-analysis" aria-label="Permalink to &quot;Subversion (SVN) Branch Analysis&quot;">​</a></h2><p>Subversion by itself does not support <em>real</em> branches, but rather uses its <em>cheap copy</em> operation and folder naming conventions for managing logical branches. For Teamscale to recognize a folder as a branch, it must either be a top-level folder <em>trunk</em> or a folder below the <em>branches directory</em> configured for the repository (defaults to <em>branches</em>). Then enable branch support and configure the URL of the SVN connector to point to the project folder, i.e., the one containing <em>trunk</em> and the configured <em>branches directory</em>. If the SVN repository in question is using <a href="http://svnbook.red-bean.com/en/1.7/svn.branchmerge.using.html" target="_blank" rel="noreferrer">the standard SVN layout</a>, then you can simply use the <em>branches directory</em> option&#39;s default.</p><p>Note that Teamscale assumes all folders directly within the <em>branches directory</em> to be actual branches. Using further folder hierarchies to organize your branches is currently not supported. More specifically, a branch name may never contain a slash. Also, as Teamscale analyzes your history, even branches that have been deleted from the <em>branches</em> folder will be found and potentially be analyzed, as they are part of the recorded history. If you want to prevent this, either set a <em>start date</em> after the time the branch was deleted or exclude the corresponding branches using the <em>branch exclude patterns</em>.</p><h2 id="subversion-authentication-problems" tabindex="-1">Subversion Authentication Problems <a class="header-anchor" href="#subversion-authentication-problems" aria-label="Permalink to &quot;Subversion Authentication Problems&quot;">​</a></h2><p>In case you are running into the problem that the SVN connector validates successfully, but the <code>SVNChangeRetriever</code> then runs into an <code>SVNAuthenticationException</code> with a <code>403 Forbidden</code> message, you can try to add the following to the entry <code>JVM_EXTRA_ARGS</code> in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code>:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dcom.teamscale.enable-svn-thorough-auth-check-support</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=true</span></span></code></pre></div><p>If it is enabled, Teamscale will do some additional authentication checks, to find the folder closest to the repository root it can access. Because this is slower than the default, it is disabled by default.</p><h2 id="azure-devops-team-foundation-version-control-credentials-formerly-called-team-foundation-server-tfs" tabindex="-1">Azure DevOps Team Foundation Version Control Credentials (formerly called Team Foundation Server (TFS)) <a class="header-anchor" href="#azure-devops-team-foundation-version-control-credentials-formerly-called-team-foundation-server-tfs" aria-label="Permalink to &quot;Azure DevOps Team Foundation Version Control Credentials (formerly called Team Foundation Server (TFS))&quot;">​</a></h2><p>When connecting to Azure DevOps TFVC via a repository connector, you may use either the account credentials of a domain user or a personal access token (if these are enabled in your Azure DevOps).</p><p>When configuring an account credential for an access token, enter the Azure DevOps access token in the <em>Access Token</em> field. The <em>Username</em> is optional in this case. By convention, you may use the name of the access token.</p><h4 id="azure-devops-boards-formerly-called-team-foundation-server-work-items" tabindex="-1">Azure DevOps Boards (formerly called Team Foundation Server Work Items) <a class="header-anchor" href="#azure-devops-boards-formerly-called-team-foundation-server-work-items" aria-label="Permalink to &quot;Azure DevOps Boards (formerly called Team Foundation Server Work Items)&quot;">​</a></h4><p>When connecting to an Azure DevOps Server via an issue connector, please verify whether the <em>Basic Authentication</em> option is enabled in your IIS or not. Depending on this option, you may need to use different credentials than you used for your repository connector when connecting to the Azure DevOps to retrieve work items.</p><h5 id="with-basic-authentication-enabled" tabindex="-1">With <em>Basic Authentication</em> enabled: <a class="header-anchor" href="#with-basic-authentication-enabled" aria-label="Permalink to &quot;With *Basic Authentication* enabled:&quot;">​</a></h5><p>You must connect with the credentials (username and password) of an Azure DevOps user account. Connecting with personal access tokens will not work. This may either be a domain user or an Azure DevOps user with the necessary rights to read work items.</p><h5 id="with-basic-authentication-disabled" tabindex="-1">With <em>Basic Authentication</em> disabled: <a class="header-anchor" href="#with-basic-authentication-disabled" aria-label="Permalink to &quot;With *Basic Authentication* disabled:&quot;">​</a></h5><p>You must connect with a personal access token. Connecting with a user account (username + password) will not work. Put the personal access token in the <em>Password</em> field in the Teamscale UI. Configuring a <em>Username</em> in Teamscale is optional in this case. By convention, you may use the name of the TFS access token.</p><h2 id="artifactory-connector-options" tabindex="-1">Artifactory Connector Options <a class="header-anchor" href="#artifactory-connector-options" aria-label="Permalink to &quot;Artifactory Connector Options&quot;">​</a></h2><p>Artifactory is a tool hosting a repository where build artifacts can be stored. Examples of such artifacts are generated code or findings generated by some external tool. It is good practice to store these in a versioned manner with a reference to the revision used to generate the given artifacts. This can be easily achieved by encoding the revision in the path of the artifact, e.g., <code>/app/component/trunk/rev1234/artifact.zip</code>.</p><p>Teamscale can extract such metadata from the artifact path and use it to link revisions in Artifactory to revisions in source-code repositories.</p><h3 id="artifactory-connector-options-1" tabindex="-1">Artifactory Connector Options <a class="header-anchor" href="#artifactory-connector-options-1" aria-label="Permalink to &quot;Artifactory Connector Options&quot;">​</a></h3><p>To extract metadata from paths, Teamscale offers a variety of extraction options that can be configured in the Artifactory Repository Connector. These options are defined by regular expressions with exactly one capturing group. The regular expression will be applied to the complete path of the imported artifact, and the content of the capturing group will be interpreted as the data to be extracted.</p><p>If the Artifactory file layout is not yet fixed, it may prove helpful to keep ease of extraction in mind when deciding on a structure. For example, paths should include the names of the fields Teamscale should extract. This allows simpler regular expressions than when having to derive the fields from the repository layout, especially if that layout is highly diverse across different projects.</p><p>Consequently, the path <code>/app/component/branch_trunk/rev_1234/artifact.zip</code> is easier to parse than the path <code>/app/component/trunk/1234/artifact.zip</code>. However, Teamscale is flexible enough to accommodate all repository structures, even when the layout is already established.</p><p>Teamscale assumes that uploads to Artifactory are typically triggered by VCS commits. Some configuration options only make sense in this light, e.g., &quot;Timestamp Interpretation&quot;. This option allows relating an Artifactory upload to some previous repository commit.</p><h4 id="artifactory-connector-configuration" tabindex="-1">Artifactory Connector Configuration <a class="header-anchor" href="#artifactory-connector-configuration" aria-label="Permalink to &quot;Artifactory Connector Configuration&quot;">​</a></h4><table><tbody><tr><td><strong>Repository</strong></td><td>The name of the Artifactory repository which contains the relevant data</td></tr><tr><td><strong>Name Search Pattern</strong></td><td>The pattern (Artifactory Query Language) on the simple file name used for finding archive files. Supported wildcards are <code>*</code> and <code>?</code>. Separate multiple patterns with comma or newline. <br>Example: <code>*.zip</code></td></tr><tr><td><strong>Zip Exclude Pattern</strong></td><td>Comma separated list of <a href="https://ant.apache.org/manual/dirtasks.html">Ant Patterns</a> used to exclude all archives whose full paths (path + name). Paths will be matched case-insensitively.</td></tr><tr><td><strong>Path Search Pattern</strong></td><td>The pattern (Artifactory Query Language) on the full path used for finding archive files. Supported wildcards are <code>*</code> and <code>?</code>. Separate multiple patterns with comma or newline. <br> Example: <code>component/subcomponent/*</code></td></tr><tr><td><strong>Public Context Path</strong></td><td>The path which will be publicly used to access Artifactory. If Artifactory is accessible on the root of the server leave empty.</td></tr><tr><td><strong>Full Scan Interval (expert option)</strong></td><td> The interval (in seconds) in which a full scan will be performed. Depending on the Artifactory instance, this can take a long time. Might be necessary to detect deletions of older items. Can be set to -1 to disable periodic full scans. Please note that only full scans will remove any revisions which have been deleted in Artifactory from Teamscale.</td></tr><tr><td><strong>Branch Extraction Pattern</strong></td><td>Pattern used to extract the branch name from the full path. A regex pattern with exactly one capturing group. The group is used to find the branch name from the archive&#39;s path. <br> Example: <code>component/(trunk|branch)/rev</code></td></tr><tr><td><strong>Timestamp Extraction Pattern</strong></td><td>Pattern used to extract the timestamp or revision from the full path. A regex pattern with exactly one capturing group. The group is used to find the timestamp name from the archive&#39;s path. If this is empty, the creation date from Artifactory will be used. <br> Example: <code>/rev(\\d+)/</code></td></tr><tr><td><strong>Max Change Detection Age</strong></td><td>Changes to the history of the artifact store downloads that are older than this age (in days) will not be detected by Teamscale.</td></tr><tr><td><strong>Timestamp Interpretation</strong></td><td> Describes how to interpret the value from timestamp extraction. Possible values are &#39;date:pattern&#39;, where pattern is a Java time format descriptor, &#39;timestamp:seconds&#39; and &#39;timestamp:millis&#39; for unix timestamps in seconds or milliseconds, &#39;svn:account-name&#39; to interpret the value as a Subversion revision, &#39;git:account-name&#39; to interpret the value as a git commit hash for a repository using the &#39;File System&#39; connector, and &#39;connector:repository-identifier&#39; to interpret the value as a revision of a connector in the same project. In &#39;connector:repository-identifier&#39;, the part after the colon can be omitted, i.e., &#39;connector&#39; is valid. In this case, Teamscale uses all other connectors to resolve the revision. This does not guarantee which revision is chosen, if multiple revisions with the same name are found by different connectors.</td></tr><tr><td><strong>Prefix Extraction Pattern</strong></td><td>Pattern used to extract an additional prefix that is placed before the name of files extracted from the ZIP files. A regex pattern with exactly one capturing group. The group is used to find the prefix from the archive&#39;s path. If this is empty, no prefix will be used. <br> Example: <code>variant/(var1|var2)/component</code>will prepend either <code>var1</code> or <code>var2</code> to the path used in Teamscale</td></tr><tr><td><strong>Ignore extraction failures (expert option)</strong></td><td> When checked, Teamscale will try to ignore errors during timestamp extraction according to the given extraction pattern. This can be useful when many non-conforming paths are expected to be analyzed alongside the conforming paths. When this is unchecked, such errors will stop the import until they are corrected (to avoid importing inconsistent data). When this option is checked, the non-conforming paths will be skipped but all conforming paths will still be imported.</td></tr><tr><td><strong>Delete Partitions Without New Uploads (expert option)</strong></td><td> Whether to discard data in partitions that have not been updated in a commit in an upload to Artifactory, instead of keeping it. (off = keep data). Turning this on is useful in scenarios, where you expect to get all relevant data with every single commit (e.g. when using only fully automated tests that are run with each commit). Turning it off is useful in the inverse scenario, e.g. when using a lot of irregular manual uploads, such as when doing manual testing for test gap analysis. </td></tr><tr><td><strong>Filter duplicate archives per revision (expert option)</strong></td><td>When activated, Teamscale will only keep the newest archive for all archives with the same simple name (without path) that are mapped to the same revision.</td></tr><tr><td><strong>Required ZIP path patterns (expert option)</strong></td><td>Comma separated list of patterns for which at least one matching path of a ZIP file must be found. If this is not the case, the revision will be skipped by the connector. This can be used to skip incomplete builds.</td></tr></tbody></table><h2 id="s3-connector" tabindex="-1">S3 Connector <a class="header-anchor" href="#s3-connector" aria-label="Permalink to &quot;S3 Connector&quot;">​</a></h2><p>The S3 connector enables Teamscale to connect to <a href="https://aws.amazon.com/s3/" target="_blank" rel="noreferrer">Amazon S3</a> or any object storage server with an API compatible with Amazon S3 cloud storage (e.g. <a href="https://min.io/" target="_blank" rel="noreferrer">MinIO</a>). The connector then fetches the data from the object storage server, whether it&#39;s generated code or data generated by some external tool (e.g. findings, code coverage, etc.). We recommend you store the objects in archives. The path to the archive must include the revision used to generate the given artifacts, as well as the branch to which they belong, e.g., <code>app/component/branch_name/rev_1234/artifact.zip</code></p><p>Teamscale can extract such metadata from the object key and use it to link revisions from the object storage server to revisions in source-code repositories.</p><h3 id="s3-connector-account-credentials" tabindex="-1">S3 Connector Account Credentials <a class="header-anchor" href="#s3-connector-account-credentials" aria-label="Permalink to &quot;S3 Connector Account Credentials&quot;">​</a></h3><p>When connecting to Amazon S3 or any S3-compatible server via the S3 connector, you must use the account credentials of a user&#39;s <strong>service account</strong>.</p><h4 id="required-user-permissions" tabindex="-1">Required User Permissions <a class="header-anchor" href="#required-user-permissions" aria-label="Permalink to &quot;Required User Permissions&quot;">​</a></h4><p>The user, whose service account will be used, must have the following <strong>action permissions</strong>:</p><ul><li>s3:GetObject</li><li>s3:ListBucket</li></ul><p>Below is a sample for an IAM policy specifically created for the Teamscale technical user with only the required permissions.</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;Version&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;2012-10-17&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;Statement&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">            &quot;Effect&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Allow&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">            &quot;Action&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">                &quot;s3:GetObject&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,  </span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">                &quot;s3:ListBucket&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">            &quot;Resource&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">                &quot;arn:aws:s3:::*&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><h4 id="account-credentials" tabindex="-1">Account Credentials <a class="header-anchor" href="#account-credentials" aria-label="Permalink to &quot;Account Credentials&quot;">​</a></h4><p>When using http(s)-based path-style links, the used account&#39;s fields should be filled out as follows:</p><ul><li><strong><em>URL</em></strong>: The base URL of the object storage server (e.g., <code>http(s)://&lt;hostname&gt;[:port]/&lt;bucket&gt;[/key]</code>).</li><li><strong><em>Access Key</em></strong>: The service account&#39;s <strong>access key</strong>.</li><li><strong><em>Secret Key</em></strong>: The service account&#39;s <strong>secret key</strong>.</li></ul><p>When using http(s)-based virtual-host-style links, the used account&#39;s fields should be filled out as follows:</p><ul><li><strong><em>URL</em></strong>: The base URL of the object storage server (e.g., <code>http(s)://&lt;bucket&gt;.&lt;hostname&gt;[:port][/key]</code>).</li><li><strong><em>Access Key</em></strong>: The service account&#39;s <strong>access key</strong>.</li><li><strong><em>Secret Key</em></strong>: The service account&#39;s <strong>secret key</strong>.</li></ul><p>When using s3-style links, the used account&#39;s fields should be filled out as follows:</p><ul><li><strong><em>URL</em></strong>: The base URL of the object storage server (e.g., <code>s3://&lt;bucket&gt;[/key]</code>). This will automatically switch to using the <a href="https://aws.amazon.com/cli/" target="_blank" rel="noreferrer">AWS CLI</a>. In this configuration style, the access key and secret key are taken from the host machine. The <strong><em>Secret Key</em></strong> and <strong><em>Access Key</em></strong> in the Teamscale configuration will be ignored and can therefore be left empty.</li></ul><div class="warning custom-block"><p class="custom-block-title">Relationship between bucket configuration and URI</p><p>The <strong><em>Bucket</em></strong> field in the connector configuration must be filled and defines the bucket used by Teamscale. The &lt;bucket&gt; in the URI must match the name given in the <strong><em>Bucket</em></strong> field.</p></div><h4 id="credentials-process" tabindex="-1">Credentials Process <a class="header-anchor" href="#credentials-process" aria-label="Permalink to &quot;Credentials Process&quot;">​</a></h4><p>An <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-sourcing-external.html">AWS credentials process</a> may be used instead of the account&#39;s username and password. To enable this functionality, you have to set the command via the <a href="./../../reference/administration-ts-installation/#jvm-settings-jvm-properties">JVM property</a> <code>-Dcom.teamscale.s3.credentials-process-command</code>. The command should correspond to an executable file accessible by Teamscale that will provide the credentials in the correct format when executed. You may optionally specify multiple environment variables in the <a href="./../../reference/admin-settings/#admin-settings-reference">admin settings</a> under the &quot;AWS Integration&quot; section. They will be added to the environment of the command. For example, if the command is <code>credentials_process</code>, it will be executed as <code>VAR1=VAL1 VAR2=VAL2 ... credentials_process</code>, where <code>VAR1</code>, <code>VAR2</code>, <em>etc.</em>, are the environment variables and their corresponding values. To avoid security risks such as potential command injection, environment variable keys and values are limited to letters and digits, i.e., a-z, A-Z, 0-9, as well as the characters &#39;.&#39; (dot), &#39;-&#39; (minus), and &#39;_&#39; (underscore). Finally, the option <a href="#s3-connector-configuration">&quot;Use Credentials Process&quot;</a> must be enabled in the connector for the credentials process to be used.</p><h3 id="s3-connector-options" tabindex="-1">S3 Connector Options <a class="header-anchor" href="#s3-connector-options" aria-label="Permalink to &quot;S3 Connector Options&quot;">​</a></h3><p>To extract metadata from objects, Teamscale offers a variety of extraction options that can be configured in the S3 Repository Connector. These options are defined by regular expressions with exactly one capturing group and/or ant patterns. The regular expression will be applied to the complete key of the imported object, and the content of the capturing group will be interpreted as the data to be extracted.</p><p>If the bucket&#39;s layout is not yet fixed, it may prove helpful to keep ease of extraction in mind when deciding on a structure. For example, object keys should include the names of the fields Teamscale should extract. This allows simpler regular expressions than when having to derive the fields from the bucket&#39;s layout, especially if that layout is highly diverse across different projects.</p><p>Consequently, the path <code>/app/component/branch_trunk/rev_1234/artifact.zip</code> is easier to parse than the path <code>/app/component/trunk/1234/artifact.zip</code>. However, Teamscale is flexible enough to accommodate all bucket structures, even when the layout is already established.</p><p>Teamscale assumes that uploads to the S3 object storage server are typically triggered by VCS commits. Some configuration options only make sense in this light, e.g., &quot;Timestamp Interpretation&quot;. This option allows relating an S3 object to some previous repository commit.</p><h4 id="s3-connector-configuration" tabindex="-1">S3 Connector Configuration <a class="header-anchor" href="#s3-connector-configuration" aria-label="Permalink to &quot;S3 Connector Configuration&quot;">​</a></h4><table><tbody><tr><td><strong>Bucket</strong></td><td>The name of the bucket which contains the relevant objects and data. It also replaces the bucket name in the s3-style URI given in the account.</td></tr><tr><td><strong>Key Prefixes</strong></td><td>Strings indicating the prefixes to be used when fetching keys from the bucket. Separate multiple strings with a comma.</td></tr><tr><td><strong>Included Key Patterns</strong></td><td>Ant patterns describing the keys to be used for finding archive files from the bucket. Supported wildcards are <code>*</code> and <code>?</code>. Separate multiple patterns with comma or newline. <br> Example: <code>*.zip</code></td></tr><tr><td><strong>Excluded Key Patterns</strong></td><td>Ant patterns describing the keys to be excluded from the bucket. Keys will be matched case-insensitively.</td></tr><tr><td><strong>Use Credentials Process</strong></td><td>If enabled, the configured <a href="#credentials-process">credentials process </a> will be used for authentication instead of the account&#39;s username and password fields.</td></tr><tr><td><strong>Branch Extraction Pattern</strong></td><td>Pattern used to extract the branch name from the full path. A regex pattern with exactly one capturing group. The group is used to find the branch name from the archive&#39;s path. <br> Example: <code>component/(trunk|branch)/rev</code></td></tr><tr><td><strong>Timestamp Extraction Pattern</strong></td><td>Pattern used to extract the timestamp or revision from the full path. A regex pattern with exactly one capturing group. The group is used to find the timestamp name from the archive&#39;s path. If this is empty, the creation date from Artifactory will be used. <br> Example: <code>/rev(\\d+)/</code></td></tr><tr><td><strong>Max Change Detection Age</strong></td><td>Changes to the history of the artifact store downloads that are older than this age (in days) will not be detected by Teamscale.</td></tr><tr><td><strong>Timestamp Interpretation</strong></td><td> Describes how to interpret the value from timestamp extraction. Possible values are &#39;date:pattern&#39;, where pattern is a Java time format descriptor, &#39;timestamp:seconds&#39; and &#39;timestamp:millis&#39; for unix timestamps in seconds or milliseconds, &#39;connector:repository-identifier&#39; to interpret the value as a revision of a connector in the same project, &#39;svn:account-name&#39; to interpret the value as a Subversion revision, and &#39;git:account-name&#39; to interpret the value as a git commit hash for a repository using the &#39;File System&#39; connector.</td></tr><tr><td><strong>Prefix Extraction Pattern</strong></td><td>Pattern used to extract an additional prefix that is placed before the name of files extracted from the ZIP files. A regex pattern with exactly one capturing group. The group is used to find the prefix from the archive&#39;s path. If this is empty, no prefix will be used. <br> Example: <code>variant/(var1|var2)/component</code>will prepend either <code>var1</code> or <code>var2</code> to the path used in Teamscale</td></tr><tr><td><strong>Ignore extraction failures (expert option)</strong></td><td> When checked, Teamscale will try to ignore errors during timestamp extraction according to the given extraction pattern. This can be useful when many non-conforming paths are expected to be analyzed alongside the conforming paths. When this is unchecked, such errors will stop the import until they are corrected (to avoid importing inconsistent data). When this option is checked, the non-conforming paths will be skipped but all conforming paths will still be imported.</td></tr><tr><td><strong>Delete Partitions Without New Uploads (expert option)</strong></td><td> Whether to discard data in partitions that have not been updated in a commit in an upload to Artifactory, instead of keeping it. (off = keep data). Turning this on is useful in scenarios, where you expect to get all relevant data with every single commit (e.g. when using only fully automated tests that are run with each commit). Turning it off is useful in the inverse scenario, e.g. when using a lot of irregular manual uploads, such as when doing manual testing for test gap analysis. </td></tr><tr><td><strong>Filter duplicate archives per revision (expert option)</strong></td><td>When activated, Teamscale will only keep the newest archive for all archives with the same simple name (without path) that are mapped to the same revision.</td></tr><tr><td><strong>Required ZIP path patterns (expert option)</strong></td><td>Comma separated list of patterns for which at least one matching path of a ZIP file must be found. If this is not the case, the revision will be skipped by the connector. This can be used to skip incomplete builds.</td></tr></tbody></table><h2 id="issue-tracker-connector-options" tabindex="-1">Issue Tracker Connector Options <a class="header-anchor" href="#issue-tracker-connector-options" aria-label="Permalink to &quot;Issue Tracker Connector Options&quot;">​</a></h2><h3 id="options-for-all-issue-tracker-connectors" tabindex="-1">Options for all Issue Tracker Connectors <a class="header-anchor" href="#options-for-all-issue-tracker-connectors" aria-label="Permalink to &quot;Options for all Issue Tracker Connectors&quot;">​</a></h3><table><tbody><tr><td><strong>Import only Items Changed After</strong></td><td>This limits <strong>which</strong> items should be imported. Example: Setting this to &quot;1 year ago&quot; implies that items which remained unchanged within the last year will not be imported. </td></tr><tr><td><strong>Issue Connector identifier</strong></td><td>Teamscale will use this identifier to distinguish different issue connectors in the same project. (Teamscale-internal only)</td></tr><tr><td><strong>Import Issue history since</strong></td><td>The start timestamp of the history to retrieve. This limits the amount of history we import for each item, but does not limit which items to import.</td></tr><tr><td><strong>Issue ID pattern in commit messages</strong></td><td>A regular expression that matches the issue ID inside commit messages. Must contain at least one capturing group. The first capturing group of the regular expression must match the entire issue ID as it is used by the issue tracker. For example, for JIRA a valid pattern might be <code>(JIRA-\\d+)</code> . If the regular expression can match alternate spellings that the issue tracker does not consider valid issue IDs, then these spellings must be normalized using an <strong>Issue ID transformation</strong> (see below). </td></tr><tr><td><strong>Issue ID pattern in branch names</strong></td><td>A regular expression that matches the issue ID inside branch names. Must contain at least one capturing group. The first capturing group of the regular expression must match the entire issue ID as it is used by the issue tracker. For example, for JIRA a valid pattern might be <code>(jira_\\d+)</code> . If the regular expression can match alternate spellings that the issue tracker does not consider valid issue IDs, then these spellings must be normalized using an <strong>Issue ID transformation</strong> (see below). </td></tr><tr><td><strong>Projects (except GitLab)</strong></td><td>A comma-separated list of project names from the issue tracker. Only issues from these projects will be imported </td></tr><tr><td>Custom Fields (except GitLab)</td><td>Custom fields to be included. This is a pair list of the field&#39;s name and a boolean indicating whether the content of the field should be interpreted as a username. Example: &#39;release-relevant -&gt; false, reviewer -&gt; true&#39;. Names must be unique within each issue. For Jira, if an issue contains multiple fields with identical names, only the first non-empty one is imported.</td></tr><tr><td><strong>Enable Change Aggregation (expert option)</strong></td><td>When enabled, Teamscale will aggregate multiple changes of the same author into a single change, improving analysis performance.</td></tr><tr><td><strong>Maximum Change Aggregation Span (expert option)</strong></td><td>The maximum interval in seconds between two subsequent changes so they can still be aggregated. This prevents changes from the same author from being aggregated when a lot of time has passed in between them. This should be shorter than the Maximum Change Aggregation Session Length.</td></tr><tr><td><strong>Maximum Change Aggregation Session Length (expert option)</strong></td><td>Maximum time span in seconds within which all changes by the same author may be aggregated. This ensures that you get new updates in Teamscale at least this often, even if the same author is continuously making changes in short succession. This should be longer than the Maximum Change Aggregation Span.</td></tr><tr><td><strong>Issue ID transformation in commit messages (expert option)</strong></td><td>A transformation expression in the form <code>original expression -&gt; transformed expression</code> which can translate the issue references in commit messages to actual issue IDs in the issue tracker. For example, <code>JIRA-(\\d+) -&gt; MY_PROJECT_KEY-$1</code> (using the <b>Issue ID pattern in commit messages</b> <code>(JIRA-\\d+)</code>).<br><b>Important</b>: <code>original expression</code> is applied to matches of the capturing groups in the <b>Issue ID pattern in commit messages</b> option (<b>not the entire commit message</b>).<br>In <code>transformed expression</code>, capturing groups from <code>original expression</code> can be referenced by <code>$1</code>, <code>$2</code>, ...</td></tr><tr><td><strong>Issue id transformation in branch names (expert option)</strong></td><td>A transformation expression in the form <code>original expression -&gt; transformed expression</code> which can translate the issue references in branch names to actual issue IDs in the issue tracker. For example, <code>jira_(\\d+) -&gt; MY_PROJECT_KEY-$1</code> (using the <b>Issue ID pattern in branch names</b> <code>(jira_\\d+)</code>).<br><b>Important</b>: <code>original expression</code> is applied to matches of the capturing groups in the <b>Issue ID pattern in branch names</b> option (<b>not the entire commit message</b>).<br>In <code>transformed expression</code>, capturing groups from <code>original expression</code> can be referenced by <code>$1</code>, <code>$2</code>, ...</td></tr><tr><td><strong>Hide resolved findings in issue badges (expert option)</strong></td><td>If enabled, all resolved findings in the badges for a single issue will be hidden.</td></tr></tbody></table><h4 id="jazz-specific-issue-tracker-connector-options" tabindex="-1">Jazz-specific Issue Tracker Connector Options <a class="header-anchor" href="#jazz-specific-issue-tracker-connector-options" aria-label="Permalink to &quot;Jazz-specific Issue Tracker Connector Options&quot;">​</a></h4><table><tbody><tr><td><strong>Item types</strong></td><td> The types of work items to retrieve. Leave empty for all item types.</td></tr><tr><td><strong>Field filter expression (expert option)</strong></td><td>A pattern to filter work items based on their fields. This is sent to the Reportable REST API and will be concatenated with a logical AND to any existing filters.</td></tr></tbody></table><h4 id="app-based-github-specific-issue-tracker-connector-options" tabindex="-1">(App based) GitHub-specific Issue Tracker Connector Options <a class="header-anchor" href="#app-based-github-specific-issue-tracker-connector-options" aria-label="Permalink to &quot;(App based) GitHub-specific Issue Tracker Connector Options&quot;">​</a></h4><p>There is no <strong>project</strong> option for this issue tracker, since this connector is directly tied to a specific repository.</p><table><tbody><tr><td><strong>Repository name</strong></td><td> The name of the repository, e.g. &#39;cqse/teamscale-python-client&#39;.</td></tr><tr><td><strong>GitHub Server URL</strong></td><td>The URL the GitHub instance is reachable at. The GitHub server URL selection dropdown menu is shown below. A How-To to connect GitHub with Teamscale can be found <a href="../../howto/connecting-github-with-app">here</a></td></tr>. </tbody></table><p><img src="`+n+'" alt="GitHub (App based) Server URL Selection Dropdown Menu" width="557" height="268"></p><h4 id="jira-specific-issue-tracker-connector-options" tabindex="-1">Jira-specific Issue Tracker Connector Options <a class="header-anchor" href="#jira-specific-issue-tracker-connector-options" aria-label="Permalink to &quot;Jira-specific Issue Tracker Connector Options&quot;">​</a></h4><table><tbody><tr><td><strong>Add to Jira issues</strong></td><td> Allows to configure active (push) update of Jira issues with analysis results from Teamscale. The Jira issue update configuration menu is shown below. An example of a Jira issue field enhanced with Teamscale-generated data can be seen in <a href="../../howto/connecting-to-issue-trackers/jira/">this guide</a>.</td></tr><tr><td><strong>Remove deleted issues (expert option)</strong></td><td>Whether issues deleted in Jira should also be deleted in Teamscale. If enabled, the first poll per day will also check for issues deleted in Jira and remove them from Teamscale. In order to detect deleted issues, every issue has to be fetched from the Jira server. This can be a rather expensive operation, even when no issues are deleted.</td></tr><tr><td><strong>Cookies (expert option)</strong></td><td>Cookies (written as <code>(&lt;domain&gt;:)?&lt;name&gt;=&lt;value&gt;</code>) to be sent along with the request.</td></tr></tbody></table><h4 id="tfs-worker-item-specific-issue-tracker-connector-options" tabindex="-1">TFS Worker Item-specific Issue Tracker Connector Options <a class="header-anchor" href="#tfs-worker-item-specific-issue-tracker-connector-options" aria-label="Permalink to &quot;TFS Worker Item-specific Issue Tracker Connector Options&quot;">​</a></h4><table><tbody><tr><td><strong>Areas</strong></td><td>A list of full area paths to extract work items from.</td></tr><tr><td><strong>Include Sub-Areas</strong></td><td>If checked, issues from sub-areas are retrieved as well, otherwise just issues exactly matching one of the area paths are retrieved.</td></tr><tr><td><strong>Item Types</strong></td><td>The types of work items to retrieve as a comma-separated list. Leave empty for all item types.</td></tr><tr><td><strong>Closed states</strong></td><td>If a work item is in one of these states it is considered closed.</td></tr><tr><td><strong>Retrieve history</strong></td><td>If checked, the full history of a work item is retrieved. This can lead to high load on the TFS-Server.</td></tr><tr><td><strong>Retrieve parent links</strong></td><td>If checked, any parent relationship will be retrieved. This can lead to more load on the TFS-Server.</td></tr></tbody></table><h4 id="rtc-jazz-specific-issue-tracker-connector-options" tabindex="-1">RTC/Jazz-specific Issue Tracker Connector Options <a class="header-anchor" href="#rtc-jazz-specific-issue-tracker-connector-options" aria-label="Permalink to &quot;RTC/Jazz-specific Issue Tracker Connector Options&quot;">​</a></h4><table><tbody><tr><td><strong>Field filter expression</strong></td><td>An expression used to filter issues that should be imported. Must conform to RTC/Jazz’s Reportable REST API specification.</td></tr><tr><td><strong>Item types</strong></td><td> Allows to select the work item types to import from RTC/Jazz. Leave empty for all item types. </td></tr></tbody></table><h4 id="gitlab-issue-tracker-connector-options" tabindex="-1">GitLab Issue Tracker Connector Options <a class="header-anchor" href="#gitlab-issue-tracker-connector-options" aria-label="Permalink to &quot;GitLab Issue Tracker Connector Options&quot;">​</a></h4><table><tbody><tr><td><strong>Project</strong></td><td>The global (numeric) project ID or the complete path (&lt;namespace&gt;/&lt;projectPath&gt;) of the project.</td></tr><tr><td><strong>Labels</strong></td><td>Comma-separated list of labels. Only issues with any of these labels are imported. Leave empty to import all issues.</td></tr></tbody></table><h4 id="commit-message-based-issue-tracker-connector-options" tabindex="-1">Commit Message-based Issue Tracker Connector Options <a class="header-anchor" href="#commit-message-based-issue-tracker-connector-options" aria-label="Permalink to &quot;Commit Message-based Issue Tracker Connector Options&quot;">​</a></h4><table><tbody><tr><td><strong>Issue subject pattern in commit messages</strong></td><td>Regular expression that extracts an issue subject from the commits (optional).</td></tr></tbody></table><h2 id="jira-server-issue-update-option-details" tabindex="-1">Jira Server Issue Update Option Details <a class="header-anchor" href="#jira-server-issue-update-option-details" aria-label="Permalink to &quot;Jira Server Issue Update Option Details&quot;">​</a></h2><p>The <strong>Add to Jira issues (expert option)</strong> allows to configure the type of Teamscale analysis results <strong>appended</strong> to Jira issues as well as the destination field(s) of Teamscale-generated data in matched issues. The following analysis results can be appended to matched Jira issues:</p><ul><li><p><em>Findings balance</em> suboption allows to update Jira issue(s) with finding badges that contain the counts of added/removed/changed code findings introduced by the respective issue(s).</p></li><li><p><em>Test gap</em> suboption allows to update Jira issue(s) with the test gap ratio of the respective issue(s). The test gap ratio also includes changes from child issues in case the Jira issue acts as a parent for other issues.</p></li></ul><p>Both suboptions are linked to the <strong>Issue</strong> perspective where all issue-related information can be viewed.</p><p>Additionally, it is possible to configure the field(s) of Jira issues that Teamscale-generated data should be appended to:</p><ul><li><p><em>Issue description</em> suboption allows to <strong>append</strong> Teamscale-generated data to issue description.</p></li><li><p><em>Custom field(s)</em> suboption allows to <strong>write</strong> Teamscale-generated data to specified custom fields. <em>This will overwrite any existing data in the field</em>. The custom fields have to be created by <em>Jira Administrator</em> and be of <em>Text Field (multi-line)</em> type.</p></li></ul><p><img src="'+a+'" alt="Jira Server Issue Update Configuration Menu" width="955" height="526" data-zoom="true"></p><h2 id="requirements-management-tool-connector-options" tabindex="-1">Requirements Management Tool Connector Options <a class="header-anchor" href="#requirements-management-tool-connector-options" aria-label="Permalink to &quot;Requirements Management Tool Connector Options&quot;">​</a></h2><h3 id="options-for-all-requirements-management-tool-connectors" tabindex="-1">Options for all Requirements Management Tool Connectors <a class="header-anchor" href="#options-for-all-requirements-management-tool-connectors" aria-label="Permalink to &quot;Options for all Requirements Management Tool Connectors&quot;">​</a></h3><table><tbody><tr><td><strong>Projects / Project ID</strong></td><td> Name of the project(s) in the requirements management tool to import spec items from. </td></tr><tr><td><strong>Requirements Connector identifier</strong></td><td> Teamscale will use this identifier to distinguish different requirements management tool connectors in the same project. (Teamscale-internal only) </td></tr><tr><td><strong>Specification item ID pattern</strong></td><td> A regular expression that matches the spec item ID inside source code entity comments. Must contain at least one capturing group. The first capturing group of the regular expression must match the entire spec item ID as it is used by the requirements management tool. For example, for Polarion a valid pattern might be <i>(DP-\\d+)</i>. </td></tr><tr><td><strong>Enable Spec Item analysis</strong></td><td> Whether Teamscale should analyze the imported Spec Items. Please note that the checks to execute have to be configured separately in the selected analysis profile. </td></tr><tr><td><strong>Spec Item types to analyse</strong></td><td> Comma separated list of Spec Item types (or type abbreviations) to analyze. If empty, all imported Spec Items will be analyzed. </td></tr><tr><td><strong>Verifies Relationships</strong></td><td> List of &#39;verifies&#39; relations between different Spec Item types. This is helpful if some spec items represent tests.<br> Example: <code>(*) --[tests]-&gt; (*)</code></td></tr><tr><td><strong>Custom fields (expert option)</strong></td><td> Allows to specify the custom fields to import with the spec items. Custom fields have to be selected separately, as they are non-standard fields that are configured for each project individually. </td></tr></tbody></table><h3 id="jira-specific-requirements-management-tool-connector-options" tabindex="-1">Jira-specific Requirements Management Tool Connector Options <a class="header-anchor" href="#jira-specific-requirements-management-tool-connector-options" aria-label="Permalink to &quot;Jira-specific Requirements Management Tool Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Issue types</strong></td><td> The mapping from the issue types that will be imported from Jira to the type abbreviations used in the UI. Typical Examples: <ul><li><code>Requirement -&gt; REQ</code></li><li><code>Issue -&gt; IS</code></li></ul></td></tr><tr><td><strong>Projects</strong></td><td> The projects (or products) in the Jira tracker that specification items are extracted from. It is possible to specify the project key or the project name. </td></tr></tbody></table><h3 id="polarion-specific-requirements-management-tool-connector-options" tabindex="-1">Polarion-specific Requirements Management Tool Connector Options <a class="header-anchor" href="#polarion-specific-requirements-management-tool-connector-options" aria-label="Permalink to &quot;Polarion-specific Requirements Management Tool Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Specification space name</strong></td><td> Allows to select the space to import the documents from. </td></tr><tr><td><strong>Document (module) ID(s)</strong></td><td> Allows to select the documents to import. The documents can be specified as a comma-separated list of document IDs and/or document ID regular expressions. </td></tr><tr><td><strong>Included work item types (expert option)</strong></td><td> Allows to select the work item types to import from Polarion (requirements, test cases, etc.) and their respective type abbreviations for use in Teamscale UI. </td></tr><tr><td><strong>Included work item link roles (expert option)</strong></td><td> Allows to select the work item links to import (duplicates, is implemented by, etc.). </td></tr><tr><td><strong>Remove deleted items (expert option)</strong></td><td> Whether specification items deleted in Polarion should also be deleted in Teamscale. If enabled, the first poll per day will also check for specification items deleted in Polarion and removes them from Teamscale. In order to detect deleted specification items, every specification item id has to be fetched from the Polarion server. This can be a rather expensive operation, even when no specification items are deleted. </td></tr><tr><td><strong>Work item link pattern (expert option)</strong></td><td> Pattern to extract work item links from the HTML of a document. This is required, in order to correctly detect items, that are in the &#39;Recycle Bin&#39; of a document. The Pattern must contain a group called <code>workItemId</code>, which matches the id of the referenced work item. </td></tr></tbody></table><h3 id="rtc-jazz-specific-requirements-management-tool-connector-options" tabindex="-1">RTC/Jazz-specific Requirements Management Tool Connector Options <a class="header-anchor" href="#rtc-jazz-specific-requirements-management-tool-connector-options" aria-label="Permalink to &quot;RTC/Jazz-specific Requirements Management Tool Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Projects</strong></td><td> The projects (or products) in the RTC tracker that specification items are extracted from. </td></tr><tr><td><strong>Item types</strong></td><td> Allows to select the work item types to import from RTC/Jazz and their respective type abbreviations for use in the Teamscale UI. </td></tr><tr><td><strong>Field filter expression (expert option)</strong></td><td> An expression used to filter work items that should be imported. Must conform to RTC/Jazz’s Reportable REST API specification. </td></tr><tr><td><strong>Custom Fields</strong></td><td> Custom fields to be included. This is a pair list of the field&#39;s name or id and a boolean indicating whether the field is user defined (true) or a standard field in RTC. For standard fields, the id must be specified; for user defined fields, the display name. Typical examples: <ul><li><code>target -&gt; false</code></li><li><code>Blocked -&gt; true</code></li></ul></td></tr><tr><td><strong>Included work item link roles (expert option)</strong></td><td> Links between work items to be included. </td></tr></tbody></table><h3 id="azure-devops-specific-requirements-management-tool-connector-options" tabindex="-1">Azure-Devops-specific Requirements Management Tool Connector Options <a class="header-anchor" href="#azure-devops-specific-requirements-management-tool-connector-options" aria-label="Permalink to &quot;Azure-Devops-specific Requirements Management Tool Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Areas</strong></td><td> The areas to extract work items from (full area paths). </td></tr><tr><td><strong>Include Sub-Areas</strong></td><td> If checked, issues from sub-areas are retrieved as well, otherwise just issues exactly matching one of the area paths are retrieved. </td></tr><tr><td><strong>Item Types</strong></td><td> The types of work items to retrieve. Leave empty for all item types. Specify type abbreviations after the arrow symbol. </td></tr><tr><td><strong>Closed states</strong></td><td> If a work item is in one of these states it is considered closed. </td></tr><tr><td><strong>Retrieve history</strong></td><td> Whether the full history of a work item should be retrieved. This can lead to high load on the TFS-Server. </td></tr><tr><td><strong>Included work item link roles (expert option)</strong></td><td> Determines how often Teamscale should clean up work items that were deleted in Azure DevOps or moved out of the configured Area(s). Depending on the number of work items, such a cleanup operation can lead to more load on the Azure DevOps server. Examples: <ul><li>A value of zero or less indicates that these work items will never be deleted.</li><li>A value of 1 indicates that Teamscale should check for deleted items during every poll.</li><li>A value of 2 indicates every second poll.</li></ul></td></tr><tr><td><strong>Perform work item cleanup on every Nth poll</strong></td><td> If checked, issues from sub-areas are retrieved as well, otherwise just issues exactly matching one of the area paths are retrieved. </td></tr><tr><td><strong>Projects</strong></td><td> The projects (or products) in the requirements management tool that spec items are extracted from. </td></tr><tr><td><strong>Custom Fields</strong></td><td> Custom fields to be included. This is a pair list of option name and a boolean indicating whether the content of the field should be interpreted as a username. Typical examples: <ul><li><code>release-relevant -&gt; false</code></li><li><code>reviewer -&gt; true</code></li></ul></td></tr><tr><td><strong>Item types representing test items (expert option)</strong></td><td> Item types (or the abbreviation) that represent test items, which Teamscale should parse and treat as tests. </td></tr></tbody></table><h3 id="codebeamer-specific-requirements-management-tool-connector-options" tabindex="-1">Codebeamer-specific Requirements Management Tool Connector Options <a class="header-anchor" href="#codebeamer-specific-requirements-management-tool-connector-options" aria-label="Permalink to &quot;Codebeamer-specific Requirements Management Tool Connector Options&quot;">​</a></h3><table><tbody><tr><td><strong>Project Names</strong></td><td> Comma separated list of the names of projects to import items from. </td></tr><tr><td><strong>Tracker Names</strong></td><td> Comma separated list of the names of trackers to import items from. </td></tr><tr><td><strong>Tracker to Types Mapping</strong></td><td> Defines a mapping from the tracker name to a certain type. This overrides the type of items retrieved from the tracker. Examples: <ul><li><code>MyBugTracker -&gt; Bug</code></li><li><code>MyTaskTracker -&gt; Task</code></li></ul></td></tr><tr><td><strong>Tracker Types</strong></td><td> The types of trackers to retrieve items from. Leave empty for all tracker types. Specify type abbreviations after the arrow symbol. </td></tr><tr><td><strong>Tracker Item Categories</strong></td><td> The categories of tracker items to retrieve. Leave empty for all tracker item categories. </td></tr><tr><td><strong>CodeBeamer Server Time Zone</strong></td><td> The time zone of the Codebeamer server. Unfortunately, Codebeamer only uses local date-time values when transmitting work items, which could result in incorrect timestamps within Teamscale. If not set, Teamscale assumes the Codebeamer server uses the same time zone as Teamscale. Typical Examples: <ul><li><code>Europe/Berlin</code></li><li><code>America/New_York</code></li></ul></td></tr><tr><td><strong>Item types representing test items (expert option)</strong></td><td> Item types (or the abbreviation) that represent test items, which Teamscale should parse and treat as tests. </td></tr><tr><td><strong>Remove deleted items (expert option)</strong></td><td> Whether tracker items deleted in Codebeamer should also be deleted in Teamscale. If enabled, the first poll per day will also check for tracker items deleted in Codebeamer and remove them from Teamscale. In order to detect deleted tracker items, every tracker item has to be fetched from the Codebeamer server. This can be a rather expensive operation, even when no tracker items are deleted. </td></tr></tbody></table><h4 id="gitlab-issues-as-requirement-management-tool" tabindex="-1">GitLab Issues as Requirement Management Tool <a class="header-anchor" href="#gitlab-issues-as-requirement-management-tool" aria-label="Permalink to &quot;GitLab Issues as Requirement Management Tool&quot;">​</a></h4><table><tbody><tr><td><strong>Project</strong></td><td>The global (numeric) project ID or the complete path (&lt;namespace&gt;/&lt;projectPath&gt;) of the project.</td></tr><tr><td><strong>Labels</strong></td><td>Comma-separated list of labels. Only issues with any of these labels are imported. Leave empty to import all issues.</td></tr></tbody></table>',131)])])}const f=t(i,[["render",d]]);export{g as __pageData,f as default};
