This check detects word sequences in specification or work items that are very similar. 
Such word sequences are called 'specification clones' and are typically created using copy & paste (and possibly modify).
The other instances of a clone are called 'siblings'.

This analysis ignores empty lines, whitespace, and certain stop words, which usually do not carry meaning (e.g., 'on', 'of', 'he', 'she', 'it', 'in', 'the', 'a').
The analysis is case-insensitive.
In the default configuration, a clone is detected when it is at least 10 words long ("minimal clone length").
Note that stop words are ignored and do not contribute to a clone's length.


# Why is This a Problem?

Specification clones are a problem for two related but distinct reasons:

1. **Increased Maintenance Effort**:
Clones unnecessarily increase the amount of text and, thus, raise the effort needed for comprehending specification items and quality assurance activities.
Changes that affect a clone should usually be propagated to all of its copies.
Localizing and modifying these copies creates significant overhead.

2. **Inconsistent Clones**:
If changes to a clone are *not* propagated to all of its siblings, the resulting inconsistencies can lead to non-uniform text styles and content.
Often, one does not even know that a piece of text has been copied elsewhere.


# How Can I Resolve This?

Use parameters and shared steps that can be referenced in multiple test cases.
