# Description
Various checks for comment usage.

# Extended Information
Detects end of line comments. Comments starting with `#EC` or `##` are ignored.

https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#put-comments-before-the-statement-they-relate-to

# Examples
**Bad example**
```abap
WRITE 2. " descriptive comment
```

**Good example**
```abap
" descriptive comment
WRITE 2.
```

# Clean ABAP Code Style Guide
```ABAP
" delegate pattern
output = calculate_result( input ).
```

Clearer than

```ABAP
" anti-pattern
output = calculate_result( input ).
" delegate pattern
```

And less invasive than

```ABAP
output = calculate_result( input ).  " delegate pattern
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/check_comments) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
