# Description
Checks that keywords have the same case. Non-keywords must be lower case.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#use-your-pretty-printer-team-settings

# Clean ABAP Code Style Guide
Always use your team settings.
Specify them under
_Menu_ > _Utilities_ > _Settings ..._ > _ABAP Editor_ > _Pretty Printer_.

Set _Indent_ and _Convert Uppercase/Lowercase_ > _Uppercase Keyword_
as agreed in your team.

> [Upper vs. Lower Case](https://github.com/SAP/styleguides/blob/main/clean-abap/sub-sections/UpperVsLowerCase.md) explains
> why we do not give clear guidance for the type case of keywords.
>
> Read more in _Chapter 5: Formatting: Team Rules_ of [Robert C. Martin's _Clean Code_].

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/keyword_case) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
