# Description
Omit the parameter name in single parameter calls

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#omit-the-parameter-name-in-single-parameter-calls

`EXPORTING` must already be omitted for this rule to take effect, https://rules.abaplint.org/exporting/

# Examples
**Bad example**
```abap
method( param = 2 ).
```

**Good example**
```abap
method( 2 ).
```

# Clean ABAP Code Style Guide
```ABAP
DATA(unique_list) = remove_duplicates( list ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
DATA(unique_list) = remove_duplicates( list = list ).
```

There are cases, however, where the method name alone is not clear enough
and repeating the parameter name may further understandability:

```ABAP
car->drive( speed = 50 ).
update( asynchronous = abap_true ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/omit_parameter_name) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
