# Description
Prefer `RAISE EXCEPTION NEW` to `RAISE EXCEPTION TYPE`

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-raise-exception-new-to-raise-exception-type

From 752 and up

# Examples
**Bad example**
```abap
RAISE EXCEPTION TYPE cx_generation_error
  EXPORTING
    previous = exception.
```

**Good example**
```abap
RAISE EXCEPTION NEW cx_generation_error( previous = exception ).
```

# Clean ABAP Code Style Guide
Note: Available from NW 7.52 onwards.

```ABAP
RAISE EXCEPTION NEW cx_generation_error( previous = exception ).
```

in general is shorter than the needlessly longer

```ABAP
RAISE EXCEPTION TYPE cx_generation_error
  EXPORTING
    previous = exception.
```

However, if you make massive use of the addition `MESSAGE`, you may want to stick with the `TYPE` variant:

```ABAP
RAISE EXCEPTION TYPE cx_generation_error
  MESSAGE e136(messages)
  EXPORTING
    previous = exception.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/prefer_raise_exception_new) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
