# Description
Checks that exceptions `system_failure` and `communication_failure` are handled in RFC calls

# Extended Information
https://help.sap.com/doc/abapdocu_750_index_htm/7.50/en-US/abenrfc_exception.htm

# Examples
**Bad example**
```abap
CALL FUNCTION 'ZRFC'
  DESTINATION lv_rfc.
```

**Good example**
```abap
CALL FUNCTION 'ZRFC'
  DESTINATION lv_rfc
  EXCEPTIONS
    system_failure        = 1 MESSAGE msg
    communication_failure = 2 MESSAGE msg
    resource_failure      = 3
    OTHERS                = 4.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/rfc_error_handling) <br>
