Python provides a number of methods that emulate the behavior of standard Linux
command line utilities. Like their Linux counterparts, these commands may take
a wildcard "\*" character in place of a file system path. This is interpreted
to mean "any and all files or folders" and can be used to build partially
qualified paths, such as "/home/user/\*".

The use of partially qualified paths may result in unintended consequences if
an unexpected file or symlink is placed into the path location given. This
becomes particularly dangerous when combined with commands used to manipulate
file permissions or copy data off of a system.

This test plugin looks for usage of the following commands in conjunction with
wild card parameters:

- 'chown'
- 'chmod'
- 'tar'
- 'rsync'

As well as any method configured in the shell or subprocess injection test
configurations.


**Config Options:**

This plugin test shares a configuration with others in the same family, namely
`shell_injection`. This configuration is divided up into three sections,
`subprocess`, `shell` and `no_shell`. They each list Python calls that spawn
subprocesses, invoke commands within a shell, or invoke commands without a
shell (by replacing the calling process) respectively.

This test will scan parameters of all methods in all sections. Note that
methods are fully qualified and de-aliased prior to checking.


``` python

shell_injection:
# Start a process using the subprocess module, or one of its wrappers.
subprocess:
- subprocess.Popen
- subprocess.call

# Start a process with a function vulnerable to shell injection.
shell:
- os.system
- os.popen
- popen2.Popen3
- popen2.Popen4
- commands.getoutput
- commands.getstatusoutput
# Start a process with a function that is not vulnerable to shell
injection.
no_shell:
- os.execl
- os.execle


```
## Example


In the following code snippet the issue is: Possible wildcard injection in call: subprocess.Popen
CWE-78 (https://cwe.mitre.org/data/definitions/78.html)
``` python
   o.popen2('/bin/chmod *')
   subp.Popen('/bin/chown *', shell=True)

```
In the following code snippet the issue is: subprocess call - check for execution of untrusted input.
CWE-78 (https://cwe.mitre.org/data/definitions/78.html)
``` python
  # Not vulnerable to wildcard injection
  subp.Popen('/bin/rsync *')
  subp.Popen("/bin/chmod *")
```
## see also:

- https://security.openstack.org
- https://en.wikipedia.org/wiki/Wildcard_character
- https://www.defensecode.com/public/DefenseCode_Unix_WildCards_Gone_Wild.txt
- https://cwe.mitre.org/data/definitions/78.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added
