# Rule 1.1 The program shall contain no violations of the standard C syntax and constraints, and shall not exceed the implementation’s translation limits

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
The program shall use only those features of the C language and its library that are specified in the chosen version of The Standard (see Section 3.1).

The Standard permits implementations to provide language extensions and the use of such extensions is permitted by this rule.

Except when making use of a language extension, a program shall not:
* Contain any violations of the language syntax described in The Standard;
* Contain any violations of the *constraints* imposed by The Standard.

A program shall not exceed the translation limits imposed by the implementation. The minimum translation limits are specified by The Standard but an implementation may provide higher limits.

Note: a conforming implementation generates a diagnostic for syntax and *constraint* violations but be aware that:
* The diagnostic need not necessarily be an error but could, for example, be a warning;
* The program may be translated and an executable generated despite the presence of a syntax or *constraint* violation;

Note: a conforming implementation does not need to generate a diagnostic when a translation limit is exceeded; an executable may be generated but it is not guaranteed to execute correctly.

## Rationale
Problems associated with language features that are outside the supported versions of ISO/IEC 9899 have not been considered during development of these guidelines.

There is anecdotal evidence of some non-conforming implementations failing to diagnose *constraint* violations, for example in [38] p135, example 2 entitled “Error of writing into the const area”.

## Example
Some C90 compilers provide support for *inline functions* using the `__inline` keyword. A C90 program that uses `__inline` will be compliant with this rule provided that it is intended to be translated using such a compiler.

Many compilers for embedded targets provide additional keywords that qualify object types with attributes of the memory area in which the object is located, for example:
* `__zpage` — the object can be accessed using a short instruction
* `__near` — a pointer to the object can be held in 16 bits
* `__far` — a pointer to the object can be held in 24 bits

A program using these additional keywords will be compliant with this rule provided that the compiler supports those keywords as a language extension.

## See also
Dir 2.1, Rule 1.2

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
