# Rule 15.4 There should be no more than one *break* or *goto* statement used to terminate any iteration statement

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
Restricting the number of exits from a loop helps to minimize visual code complexity. The use of one
*break* or *goto* statement allows a single secondary exit path to be created when early loop termination
is required.

## Example
Both of the following nested loops are compliant as each has a single *break* used for early loop
termination.
```c
for ( x = 0; x < LIMIT; ++x )
{
 if ( ExitNow ( x ) )
 {
 break;
 }
 for ( y = 0; y < x; ++y )
 {
 if ( ExitNow ( LIMIT - y ) )
 {
 break;
 }
 }
}
```
The following loop is non-compliant as there are multiple *break* and *goto* statements used for early
loop termination.
```c
for ( x = 0; x < LIMIT; ++x )
{
 if ( BreakNow ( x ) )
 {
 break;
 }
 else if ( GotoNow ( x ) )
 {
 goto EXIT;
 }
 else
 {
 KeepGoing ( x );
 }
}
EXIT:
 ;
```
In the following example, the inner *while* loop is compliant because there is a single *goto* statement
that can cause its early termination. However, the outer *while* loop is non-compliant because it can be
terminated early either by the *break* statement or by the *goto* statement in the inner *while* loop.
```c
while ( x != 0u )
{
 x = calc_new_x ( );
 if ( x == 1u )
 {
 break;
 }
 while ( y != 0u )
 {
 y = calc_new_y ( );
 if ( y == 1u )
 {
 goto L1;
 }
 }
}
L1:
z = x + y;
```

## See also
Rule 15.1, Rule 15.2, Rule 15.3

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
