# Rule 17.6 The declaration of an array parameter shall not contain the *static* keyword between the `[ ]`

## Category
Mandatory

## Analysis
Decidable, Single Translation Unit

## Applies to
C99

## Rationale
The C99 language standard provides a mechanism for the programmer to inform the compiler that an
array parameter contains a specified minimum number of elements. Some compilers are able to take
advantage of this information to generate more efficient code for some types of processor.

If the guarantee made by the programmer is not honoured, and the number of elements is less than
the minimum specified, the behaviour is undefined.

The processors used in typical embedded applications are unlikely to provide the facilities required
to take advantage of the additional information provided by the programmer. The risk of the program
failing to meet the guaranteed minimum number of elements outweighs any potential performance
increase.

## Example
There is no use of this C99 language feature that is compliant with this rule. The examples show some
of the undefined behaviour that can arise from its use.
```c
/* Non-compliant - uses static in array declarator */
uint16_t total ( uint16_t n, uint16_t a[ static 20 ] )
{
 uint16_t i;
 uint16_t sum = 0U;
 /* Undefined behaviour if a has fewer than 20 elements */
 for ( i = 0U; i < n; ++i )
 {
 sum = sum + a[ i ];
 }
 return sum;
}
extern uint16_t v1[ 10 ];
extern uint16_t v2[ 20 ];
void g ( void )
{
 uint16_t x;
 x = total ( 10U, v1 ); /* Undefined - v1 has 10 elements but needs
 * at least 20 */
 x = total ( 20U, v2 ); /* Defined but non-compliant */
}
```

## See also
Rule 17.5

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
