# Rule 7.1 Octal constants shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
Developers writing constants that have a leading zero might expect them to be interpreted as decimal constants.

Note: this rule does not apply to octal escape sequences because the use of a leading `\` character means that there is less scope for confusion.

## Exception
The integer constant zero (written as a single numeric digit), is strictly speaking an octal constant, but is a permitted exception to this rule.

## Example
```c
extern uint16_t code[ 10 ];

code[ 1 ] = 109;    /* Compliant - decimal 109 */
code[ 2 ] = 100;    /* Compliant - decimal 100 */
code[ 3 ] = 052;    /* Non-Compliant - decimal 42 */
code[ 4 ] = 071;    /* Non-Compliant - decimal 57 */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
