# Rule 10.6 The value of a composite expression shall not be assigned to an object with wider essential type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
This rule covers the assigning operations described in Rule 10.3.
## Rationale
The rationale is described in the introduction on *composite operators and expressions* (see Section 8.10.3).
## Example
```c
/* The following are compliant: */
u16c = u16a + u16b; /* Same essential type */
u32a = ( uint32_t ) u16a + u16b; /* Cast causes addition in uint32_t */

/* The following are non-compliant: */
u32a = u16a + u16b; /* Implicit conversion on assignment */
use_uint32 ( u16a + u16b ); /* Implicit conversion of fn argument */
```
## See also
Rule 10.3, Rule 10.7, Section 8.10.3

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
