# Rule 17.10 A function declared with a _Noreturn function specifier shall have void return type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C11
## Rationale
By definition, use of the *_Noreturn* function specifier indicates unambiguously that a function will not return to its caller.
A function that cannot return cannot provide a return value and shall therefore be defined with a *void* return type.
## Example
```c
_Noreturn int32_t f ( void ); /* Non-compliant */
_Noreturn void g ( void ); /* Compliant */
```
## See also
Rule 17.9, Rule 17.11

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
