# Rule 18.8 Variable-length arrays shall not be used
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C99, C11
## Rationale
Variable-length arrays are specified when the size of an array declared in a block or a function prototype is not an *integer constant expression*. They are typically implemented as a variable size object stored on the stack. Their use can therefore make it impossible to determine statically the amount of memory that must be reserved for a stack.
If the size of a variable-length array is negative or zero, the behaviour is undefined.
If a variable-length array is used in a context in which its type is required to be compatible with the type of another array, then the size of the array types shall be identical. Further, all sizes shall evaluate to positive integers. If these requirements are not met, the behaviour is undefined.
If a variable-length array is used in the operand of a *sizeof* operator, under some circumstances it is unspecified whether the array size expression is evaluated or not.
Each instance of a variable-length array type has its size fixed at the start of its lifetime. This gives rise to behaviour that might be confusing, for example:
```c
void f ( void )
{
 uint16_t n = 5;
 typedef uint16_t Vector[ n ]; /* An array type with 5 elements */
 n = 7;
 Vector a1; /* An array type with 5 elements */
 uint16_t a2[ n ]; /* An array type with 7 elements */
}
```
## Example
There is no use of variable-length arrays that is compliant with this rule. The examples show some of the undefined behaviour that can arise from their use.
```c
void f ( int16_t n )
{
 uint16_t vla[ n ]; /* Non-compliant - Undefined if n <= 0 */
}

void g ( void )
{
 f ( 0 ); /* Undefined */
 f ( -1 ); /* Undefined */
 f ( 10 ); /* Defined */
}
```
## See also
Rule 13.6, Rule 18.10

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
