# Rule 20.11 A macro parameter immediately following a # operator shall not immediately be followed by a ## operator
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
The order of evaluation associated with multiple `#`, multiple `##` or a mix of `#` and `##` preprocessor operators is unspecified. The use of `#` and `##` is discouraged by Rule 20.10. In particular, the result of a `#` operator is a string literal and it is extremely unlikely that pasting this to any other preprocessing token will result in a valid token.
## Example
```c
#define A( x ) #x /* Compliant */
#define B( x, y ) x ## y /* Compliant */
#define C( x, y ) #x ## y /* Non-compliant */
```
## See also
Rule 20.10

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
