# Rule 8.12 Within an enumerator list, the value of an implicitly-specified enumeration constant shall be unique

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Rationale

An implicitly-specified enumeration constant has a value 1 greater than its predecessor. If the first enumeration constant is implicitly-specified then its value is 0. An explicitly-specified enumeration constant has the value of the associated constant expression.

If implicitly-specified and explicitly-specified constants are mixed within an enumeration list, it is possible for values to be replicated. Such replication may be unintentional and may give rise to unexpected behaviour. This rule requires that any replication of enumeration constants be made explicit, thus making the intent clear. 

## Example

In the following examples the `green` and `yellow` enumeration constants are given the same value.

```c
/* Non-compliant - yellow replicates implicit green */
enum colour { red = 3, blue, green, yellow = 5 };

/* Compliant */
enum colour { red = 3, blue, green = 5, yellow = 5 };

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
