# Dir 4.14 The validity of values received from external sources shall be checked 

## Category

Required 

## Applies to

C90, C99, C11 

## Amplification

"External sources" include data: 
* Read from a file; 
* Read from an environment variable; 
* Resulting from user input; 
* Received over a communications channel. 

## Rationale

A program has no control over the values given to data originating from external sources. The values may therefore be invalid, either as the result of errors or due to malicious modification by an external agent. Data from external sources shall therefore be validated before it is used. 

In the security domain, external sources of data are usually regarded as untrusted as they may have been modified by someone trying to harm or gain control of the program and/or system it is running on; such data needs to be validated before it can be used safely. 

In the safety domain, external sources are regarded as "suspicious" and values obtained from them require validation. 

In both domains, data from an external source shall be tested to ensure that its value respects all the constraints placed on its use (i.e. its value is not harmful), even if the value cannot be proven to be correct. 

For example:
* A value used to compute an array index shall not result in an array bounds error; 
* A value used to control a loop shall not cause excessive (e.g. infinite) iteration; 
* A value used to compute a divisor shall not result in division by zero; 
* A value used to compute an amount of dynamic memory shall not result in excessive memory allocation; 
* A string used as a query to an SQL database shall be checked to ensure that it does not include a character. 

## Example

The following example is non-compliant as there is no check made to ensure that a string resulting from user input is null terminated. This may lead to an array bounds error, commonly known as a buffer overrun, when the string is output through the call to printf. 

```c
void f1 (void)
{
    char input [128];
    (void) scanf ("%128c", input);
    (void) printf ("%s", input); /* Non-compliant */
}

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
