# Dir 4.3 Assembly language shall be encapsulated and isolated 

## Category

Required 

## Applies to

C90, C99, C11 

## Amplification

Where assembly language instructions are used they shall be encapsulated and isolated in: 
* Assembly language functions; 
* C functions (inline functions preferred for C99 and later); 
* C macros. 

Note: the use of in-line assembly language is an extension to standard C, and therefore violates Rule 1.2. 

## Rationale

For reasons of efficiency it is sometimes necessary to embed simple assembly language instructions in-line, for example to enable and disable interrupts. If this is necessary, then it is recommended that it be achieved by using macros or inline functions. 

Encapsulating assembly language is beneficial because: 
* It improves readability; 
* The name, and documentation, of the encapsulating macro or function makes the intent of the assembly language clear; 
* All uses of assembly language for a given purpose can share the same encapsulation which improves maintainability; 
* The assembly language can easily be substituted for a different target or for purposes of static analysis. 

## Example

```c
#define NOP asm(" NOP")

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
