# Rule 13.1 Initializer lists shall not contain persistent side effects

## Category
Required

## Analysis
Undecidable, System

## Applies to
C99, C11

## Rationale
C90 constrains the initializers for automatic objects with aggregate types to contain only *constant expressions*. However, later editions of the C Standard permit automatic aggregate initializers to contain expressions that are evaluated at run-time. It also permits compound literals which behave as anonymous initialized objects. The order in which *side effects* occur during evaluation of the expressions in an initializer list is unspecified and the behaviour of the initialization is therefore unpredictable if those *side effects* are *persistent*.

## Example
```c
volatile uint16_t v1;

void f ( void )
{
  /* Non-compliant - volatile access is persistent side effect */
  uint16_t a[ 2 ] = { v1, 0 };
}

void g ( uint16_t x, uint16_t y )
{
  /* Compliant - no side effects */
  uint16_t a[ 2 ] = { x + y, x - y };
}

uint16_t x = 0u;

extern void p ( uint16_t a[ 2 ] );

void h ( void )
{
  /* Non-compliant - two side effects */
  p ( ( uint16_t[ 2 ] ) { x++, x++ } );
}
```

## See also
Rule 13.2

---

Copyright The MISRA Consortium Limited © [Date - March 2025].